/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util.sort.support;

import java.util.List;
import org.cp.elements.lang.ObjectUtils;
import org.cp.elements.util.sort.AbstractSorter;
import org.cp.elements.util.sort.Sorter;
import org.cp.elements.util.sort.support.InsertionSort;

public class QuickSort
extends AbstractSorter {
    protected static final int DEFAULT_SIZE_THRESHOLD = 7;
    protected static final Sorter DEFAULT_SORTER = new InsertionSort();
    private int sizeThreshold = 7;
    private Sorter sorter = DEFAULT_SORTER;

    public int getSizeThreshold() {
        return Math.max(this.sizeThreshold, 7);
    }

    public void setSizeThreshold(int sizeThreshold) {
        this.sizeThreshold = sizeThreshold;
    }

    public Sorter getSorter() {
        return ObjectUtils.defaultIfNull(this.sorter, DEFAULT_SORTER);
    }

    public void setSorter(Sorter sorter) {
        this.sorter = sorter;
    }

    @Override
    public <E> List<E> sort(List<E> elements) {
        int elementsSize = elements.size();
        if (elementsSize <= this.getSizeThreshold()) {
            return this.getSorter().sort(elements);
        }
        int beginIndex = 1;
        int endIndex = elementsSize - 1;
        E pivotElement = elements.get(0);
        while (beginIndex < endIndex) {
            while (beginIndex < endIndex && this.getOrderBy().compare(elements.get(beginIndex), pivotElement) <= 0) {
                ++beginIndex;
            }
            while (endIndex >= beginIndex && this.getOrderBy().compare(elements.get(endIndex), pivotElement) >= 0) {
                --endIndex;
            }
            if (beginIndex >= endIndex) continue;
            this.swap(elements, beginIndex, endIndex);
        }
        this.swap(elements, 0, endIndex);
        this.sort(elements.subList(0, endIndex));
        this.sort(elements.subList(endIndex + 1, elementsSize));
        return elements;
    }
}

