/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.util.zip;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.cp.elements.io.FileUtils;
import org.cp.elements.io.IOUtils;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.ElementsExceptionsFactory;
import org.cp.elements.lang.StringUtils;

public abstract class ZipUtils {
    public static final String ZIP_FILE_EXTENSION = ".zip";

    protected static ZipEntry newZipEntry(File zipDirectory, File file) {
        Assert.notNull(file, "File is required", new Object[0]);
        ZipEntry zipEntry = new ZipEntry(ZipUtils.resolveZipEntryName(zipDirectory, file));
        zipEntry.setSize(file.getTotalSpace());
        zipEntry.setTime(file.lastModified());
        return zipEntry;
    }

    static String resolveZipEntryName(File zipDirectory, File file) {
        return Optional.ofNullable(zipDirectory).filter(File::isDirectory).map(File::getName).filter(StringUtils::hasText).map(zipDirectoryName -> {
            String filePath = file.getAbsolutePath();
            int index = filePath.indexOf((String)zipDirectoryName);
            return index > -1 ? filePath.substring(index) : null;
        }).orElseGet(file::getName);
    }

    public static void unzip(File zip, File directory) throws IOException {
        Assert.notNull(zip, "ZIP file is required", new Object[0]);
        Assert.isTrue(FileUtils.createDirectory(directory), String.format("[%s] is not a valid directory", directory), new Object[0]);
        ZipFile zipFile = new ZipFile(zip, 1);
        zipFile.stream().forEach(zipEntry -> {
            if (zipEntry.isDirectory()) {
                Assert.state(FileUtils.createDirectory(new File(directory, zipEntry.getName())), ElementsExceptionsFactory.newSystemException("Failed to create directory [%s] for ZIP entry", zipEntry.getName()));
                return;
            }
            DataInputStream entryInputStream = null;
            DataOutputStream entryOutputStream = null;
            try {
                File zipEntryFile = new File(directory, zipEntry.getName());
                Assert.state(FileUtils.createDirectory(zipEntryFile.getParentFile()), ElementsExceptionsFactory.newSystemException("Failed to create directory [%1$s] for entry [%2$s]", zipEntryFile.getParent(), zipEntry.getName()));
                Assert.state(zipEntryFile.createNewFile(), ElementsExceptionsFactory.newSystemException("Filed to create file [%1$s] for entry [%2$s]", zipEntryFile, zipEntry.getName()));
                entryInputStream = new DataInputStream(zipFile.getInputStream((ZipEntry)zipEntry));
                entryOutputStream = new DataOutputStream(new FileOutputStream(zipEntryFile));
                IOUtils.copy(entryInputStream, entryOutputStream);
            }
            catch (IOException cause) {
                try {
                    throw ElementsExceptionsFactory.newSystemException(cause, "Failed to unzip entry [%s]", zipEntry.getName());
                }
                catch (Throwable throwable) {
                    IOUtils.close(entryInputStream);
                    IOUtils.close(entryOutputStream);
                    throw throwable;
                }
            }
            IOUtils.close(entryInputStream);
            IOUtils.close(entryOutputStream);
        });
    }

    public static File zip(File directory) throws IOException {
        Assert.isTrue(FileUtils.isDirectory(directory), "[%s] is not a valid directory", directory);
        File zip = new File(directory.getParent(), directory.getName().concat(ZIP_FILE_EXTENSION));
        Assert.state(zip.createNewFile(), "Failed to create new ZIP file [%s]", zip);
        try (ZipOutputStream outputStream = new ZipOutputStream(new FileOutputStream(zip, false));){
            ZipUtils.zip(directory, directory, outputStream);
            outputStream.finish();
        }
        return zip;
    }

    private static void zip(File zipDirectory, File relativeDirectory, ZipOutputStream outputStream) {
        Assert.isTrue(FileUtils.isDirectory(relativeDirectory), "[%s] is not a valid directory", relativeDirectory);
        Arrays.stream(relativeDirectory.listFiles()).forEach(file -> {
            if (file.isDirectory()) {
                ZipUtils.zip(zipDirectory, file, outputStream);
            } else {
                ZipUtils.zipEntry(zipDirectory, file, outputStream);
            }
        });
    }

    static ZipOutputStream zipEntry(File zipDirectory, File path, ZipOutputStream outputStream) {
        return ZipUtils.zipEntry(ZipUtils.newZipEntry(zipDirectory, path), outputStream);
    }

    static ZipOutputStream zipEntry(ZipEntry entry, ZipOutputStream outputStream) {
        try {
            outputStream.putNextEntry(entry);
        }
        catch (IOException cause) {
            throw ElementsExceptionsFactory.newSystemException(cause, "Failed to zip entry [%s]", entry.getName());
        }
        IOUtils.doSafeIo(outputStream::closeEntry);
        return outputStream;
    }
}

