/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.cyclonedx.maven.BaseCycloneDxMojo;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ext.dependencyGraph.Dependency;

@Mojo(name="makeAggregateBom", defaultPhase=LifecyclePhase.VERIFY, aggregator=true, requiresOnline=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class CycloneDxAggregateMojo
extends BaseCycloneDxMojo {
    public void execute() throws MojoExecutionException {
        boolean shouldSkip = Boolean.parseBoolean(System.getProperty("cyclonedx.skip", Boolean.toString(this.getSkip())));
        if (shouldSkip) {
            this.getLog().info((CharSequence)"Skipping CycloneDX");
            return;
        }
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        LinkedHashSet<String> componentRefs = new LinkedHashSet<String>();
        Set<Dependency> dependencies = new LinkedHashSet<Dependency>();
        for (MavenProject mavenProject : this.getReactorProjects()) {
            for (Artifact artifact : mavenProject.getArtifacts()) {
                if (!this.shouldInclude(artifact)) continue;
                Component component = this.convert(artifact);
                boolean found = false;
                for (String s : componentRefs) {
                    if (s == null || !s.equals(component.getBomRef())) continue;
                    found = true;
                }
                if (found) continue;
                componentRefs.add(component.getBomRef());
                components.add(component);
            }
        }
        if (this.getIncludeDependencyGraph().booleanValue() && !this.getSchemaVersion().equals("1.0")) {
            dependencies = this.buildDependencyGraph(componentRefs);
        }
        super.execute(components, dependencies);
    }
}

