/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.cyclonedx.maven.BaseCycloneDxMojo;
import org.cyclonedx.maven.ProjectDependenciesConverter;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;

@Mojo(name="makePackageBom", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, aggregator=true, requiresOnline=true, requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class CycloneDxPackageMojo
extends BaseCycloneDxMojo {
    @Parameter(property="reactorProjects", readonly=true, required=true)
    private List<MavenProject> reactorProjects;

    protected boolean shouldInclude(MavenProject mavenProject) {
        return Arrays.asList("war", "ear").contains(mavenProject.getPackaging());
    }

    @Override
    protected String extractComponentsAndDependencies(Set<String> topLevelComponents, Map<String, Component> components, Map<String, Dependency> dependencies) throws MojoExecutionException {
        this.getLog().info((CharSequence)"CycloneDX: Resolving Dependencies");
        for (MavenProject mavenProject : this.reactorProjects) {
            if (!this.shouldInclude(mavenProject)) continue;
            this.getLog().info((CharSequence)("Analyzing " + mavenProject.getArtifactId()));
            ProjectDependenciesConverter.BomDependencies bomDependencies = this.extractBOMDependencies(mavenProject);
            Map<String, Dependency> projectDependencies = bomDependencies.getDependencies();
            Component projectBomComponent = this.convert(mavenProject.getArtifact());
            components.put(projectBomComponent.getPurl(), projectBomComponent);
            topLevelComponents.add(projectBomComponent.getPurl());
            this.populateComponents(topLevelComponents, components, bomDependencies.getArtifacts(), null);
            projectDependencies.forEach(dependencies::putIfAbsent);
        }
        return "makePackageBom";
    }
}

