/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilderException;
import org.apache.maven.shared.dependency.graph.internal.DefaultDependencyCollectorBuilder;
import org.cyclonedx.maven.DefaultModelConverter;
import org.cyclonedx.maven.DelegatingRepositorySystem;
import org.cyclonedx.maven.ModelConverter;
import org.cyclonedx.maven.ProjectDependenciesConverter;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;
import org.cyclonedx.model.Metadata;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.graph.DependencyNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultProjectDependenciesConverter
implements ProjectDependenciesConverter {
    private final Logger logger = LoggerFactory.getLogger(DefaultModelConverter.class);
    @Inject
    private MavenSession session;
    @Inject
    private ModelConverter modelConverter;
    @Inject
    private RepositorySystem aetherRepositorySystem;
    private Set<String> excludeTypesSet;
    private ProjectDependenciesConverter.MavenDependencyScopes include;

    @Override
    public ProjectDependenciesConverter.BomDependencies extractBOMDependencies(MavenProject mavenProject, ProjectDependenciesConverter.MavenDependencyScopes include, String[] excludeTypes) throws MojoExecutionException {
        this.include = include;
        this.excludeTypesSet = new HashSet<String>(Arrays.asList(excludeTypes));
        ProjectBuildingRequest buildingRequest = this.getProjectBuildingRequest(mavenProject);
        LinkedHashMap<String, Dependency> dependencies = new LinkedHashMap<String, Dependency>();
        LinkedHashMap<String, Artifact> mavenArtifacts = new LinkedHashMap<String, Artifact>();
        try {
            DelegatingRepositorySystem delegateRepositorySystem = new DelegatingRepositorySystem(this.aetherRepositorySystem);
            DefaultDependencyCollectorBuilder dependencyCollectorBuilder = new DefaultDependencyCollectorBuilder((RepositorySystem)delegateRepositorySystem);
            org.apache.maven.shared.dependency.graph.DependencyNode mavenRoot = dependencyCollectorBuilder.collectDependencyGraph(buildingRequest, null);
            this.populateArtifactMap(mavenArtifacts, mavenRoot, false);
            CollectResult collectResult = delegateRepositorySystem.getCollectResult();
            if (collectResult == null) {
                throw new MojoExecutionException("Failed to generate aether dependency graph");
            }
            DependencyNode root = collectResult.getRoot();
            HashSet<String> loggedFilteredArtifacts = new HashSet<String>();
            this.buildDependencyGraphNode(dependencies, root, null, null, loggedFilteredArtifacts);
        }
        catch (DependencyCollectorBuilderException e) {
            this.logger.warn("An error occurred building dependency graph: " + e.getMessage());
        }
        return new ProjectDependenciesConverter.BomDependencies(dependencies, mavenArtifacts);
    }

    private void populateArtifactMap(Map<String, Artifact> artifactMap, org.apache.maven.shared.dependency.graph.DependencyNode node, boolean resolve) {
        Artifact artifact = node.getArtifact();
        String purl = this.modelConverter.generatePackageUrl(artifact);
        artifactMap.putIfAbsent(purl, artifact);
        for (org.apache.maven.shared.dependency.graph.DependencyNode child : node.getChildren()) {
            this.populateArtifactMap(artifactMap, child, true);
        }
    }

    private boolean isFilteredNode(DependencyNode node, Set<String> loggedFilteredArtifacts) {
        String purl;
        String key;
        Boolean scoped;
        Map nodeData = node.getData();
        String originalScope = (String)nodeData.get("conflict.originalScope");
        String scope = originalScope != null ? originalScope : node.getDependency().getScope();
        switch (scope) {
            case "compile": {
                scoped = this.include.compile;
                break;
            }
            case "provided": {
                scoped = this.include.provided;
                break;
            }
            case "runtime": {
                scoped = this.include.runtime;
                break;
            }
            case "system": {
                scoped = this.include.system;
                break;
            }
            case "test": {
                scoped = this.include.test;
                break;
            }
            default: {
                scoped = Boolean.FALSE;
            }
        }
        boolean result = Boolean.FALSE.equals(scoped);
        if (result && this.logger.isDebugEnabled() && loggedFilteredArtifacts.add(key = (purl = this.modelConverter.generatePackageUrl(node.getArtifact())) + ":" + originalScope + ":" + node.getDependency().getScope())) {
            this.logger.debug("Filtering " + purl + " with original scope " + originalScope + " and scope " + node.getDependency().getScope());
        }
        return result;
    }

    private boolean isExcludedNode(DependencyNode node) {
        String type = (String)node.getArtifact().getProperties().get("type");
        return type == null || this.excludeTypesSet.contains(type);
    }

    private void buildDependencyGraphNode(Map<String, Dependency> dependencies, DependencyNode node, Dependency parent, String parentClassifierlessPUrl, Set<String> loggedFilteredArtifacts) {
        String purl;
        Map nodeData;
        DependencyNode winner;
        if (this.isExcludedNode(node) || parent != null && this.isFilteredNode(node, loggedFilteredArtifacts)) {
            return;
        }
        if (node.getChildren().isEmpty() && (winner = (DependencyNode)(nodeData = node.getData()).get("conflict.winner")) != null) {
            node = winner;
        }
        if (!dependencies.containsKey(purl = this.modelConverter.generatePackageUrl(node.getArtifact()))) {
            Dependency topDependency = new Dependency(purl);
            dependencies.put(purl, topDependency);
            String nodeClassifierlessPUrl = this.modelConverter.generateClassifierlessPackageUrl(node.getArtifact());
            if (!nodeClassifierlessPUrl.equals(parentClassifierlessPUrl)) {
                for (DependencyNode childrenNode : node.getChildren()) {
                    this.buildDependencyGraphNode(dependencies, childrenNode, topDependency, nodeClassifierlessPUrl, loggedFilteredArtifacts);
                }
            }
        }
        if (parent != null) {
            parent.addDependency(new Dependency(purl));
        }
    }

    private ProjectBuildingRequest getProjectBuildingRequest(MavenProject mavenProject) {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setProject(mavenProject);
        return buildingRequest;
    }

    @Override
    public void cleanupBomDependencies(Metadata metadata, Map<String, Component> components, Map<String, Dependency> dependencies) {
        HashSet dependsOns = new HashSet();
        dependencies.values().forEach(d -> {
            if (d.getDependencies() != null) {
                d.getDependencies().forEach(on -> dependsOns.add(on.getRef()));
            }
        });
        Iterator<Map.Entry<String, Component>> it = components.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Component> entry = it.next();
            if (!dependencies.containsKey(entry.getKey())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Component reference not listed in dependencies, pruning from bom components: " + entry.getKey());
                }
                it.remove();
                continue;
            }
            if (dependsOns.contains(entry.getKey())) continue;
            this.logger.warn("BOM dependency listed but is not depended upon: " + entry.getKey());
        }
        Component main = metadata.getComponent();
        String mainBomRef = main.getBomRef();
        for (String dependencyRef : dependencies.keySet()) {
            if (mainBomRef.equals(dependencyRef) || components.containsKey(dependencyRef)) continue;
            this.logger.warn("Dependency missing component entry: " + dependencyRef);
        }
    }
}

