/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.rest.fieldmanager;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.rest.RESTUtils;
import org.datanucleus.api.rest.orgjson.JSONArray;
import org.datanucleus.api.rest.orgjson.JSONException;
import org.datanucleus.api.rest.orgjson.JSONObject;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.TypeConversionHelper;

public class FromJSONFieldManager
extends AbstractFieldManager {
    JSONObject jsonobj;
    AbstractClassMetaData cmd;
    ExecutionContext ec;
    ObjectProvider op;

    public FromJSONFieldManager(JSONObject jsonobj, AbstractClassMetaData cmd, ExecutionContext ec) {
        this.jsonobj = jsonobj;
        this.cmd = cmd;
        this.ec = ec;
    }

    public FromJSONFieldManager(JSONObject jsonobj, AbstractClassMetaData cmd, ObjectProvider op) {
        this.jsonobj = jsonobj;
        this.cmd = cmd;
        this.op = op;
        this.ec = op.getExecutionContext();
    }

    public boolean fetchBooleanField(int position) {
        String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
        if (!this.jsonobj.has(fieldName)) {
            return false;
        }
        try {
            boolean val = this.jsonobj.getBoolean(fieldName);
            if (this.op != null) {
                this.op.makeDirty(position);
            }
            return val;
        }
        catch (JSONException e) {
            NucleusLogger.DATASTORE_RETRIEVE.warn((Object)"Exception in fetch of boolean field", (Throwable)e);
            return false;
        }
    }

    public byte fetchByteField(int position) {
        String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
        if (!this.jsonobj.has(fieldName)) {
            return 0;
        }
        try {
            String str = this.jsonobj.getString(fieldName);
            byte value = 0;
            if (str != null && str.length() > 0) {
                value = str.getBytes()[0];
            }
            if (this.op != null) {
                this.op.makeDirty(position);
            }
            return value;
        }
        catch (JSONException jSONException) {
            return 0;
        }
    }

    public char fetchCharField(int position) {
        String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
        if (!this.jsonobj.has(fieldName)) {
            return '\u0000';
        }
        try {
            String str = this.jsonobj.getString(fieldName);
            char value = '\u0000';
            if (str != null && str.length() > 0) {
                value = str.charAt(0);
            }
            if (this.op != null) {
                this.op.makeDirty(position);
            }
            return value;
        }
        catch (JSONException jSONException) {
            return '\u0000';
        }
    }

    public double fetchDoubleField(int position) {
        String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
        if (!this.jsonobj.has(fieldName)) {
            return 0.0;
        }
        try {
            double val = this.jsonobj.getDouble(fieldName);
            if (this.op != null) {
                this.op.makeDirty(position);
            }
            return val;
        }
        catch (JSONException jSONException) {
            return 0.0;
        }
    }

    public float fetchFloatField(int position) {
        String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
        if (!this.jsonobj.has(fieldName)) {
            return 0.0f;
        }
        try {
            float val = (float)this.jsonobj.getDouble(fieldName);
            if (this.op != null) {
                this.op.makeDirty(position);
            }
            return val;
        }
        catch (JSONException jSONException) {
            return 0.0f;
        }
    }

    public int fetchIntField(int position) {
        String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
        if (!this.jsonobj.has(fieldName)) {
            return 0;
        }
        try {
            int val = this.jsonobj.getInt(fieldName);
            if (this.op != null) {
                this.op.makeDirty(position);
            }
            return val;
        }
        catch (JSONException jSONException) {
            return 0;
        }
    }

    public long fetchLongField(int position) {
        String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
        if (!this.jsonobj.has(fieldName)) {
            return 0L;
        }
        try {
            long val = this.jsonobj.getLong(fieldName);
            if (this.op != null) {
                this.op.makeDirty(position);
            }
            return val;
        }
        catch (JSONException jSONException) {
            return 0L;
        }
    }

    public short fetchShortField(int position) {
        String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
        if (!this.jsonobj.has(fieldName)) {
            return 0;
        }
        try {
            short val = (short)this.jsonobj.getInt(fieldName);
            if (this.op != null) {
                this.op.makeDirty(position);
            }
            return val;
        }
        catch (JSONException jSONException) {
            return 0;
        }
    }

    public String fetchStringField(int position) {
        String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
        if (!this.jsonobj.has(fieldName)) {
            return null;
        }
        try {
            String val = this.jsonobj.getString(fieldName);
            if (this.op != null) {
                this.op.makeDirty(position);
            }
            return val;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public Object fetchObjectField(int position) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position);
        if (!this.jsonobj.has(mmd.getName())) {
            return null;
        }
        try {
            if (this.jsonobj.isNull(mmd.getName())) {
                if (this.op != null) {
                    this.op.makeDirty(position);
                }
                return null;
            }
            Object value = this.jsonobj.get(mmd.getName());
            ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
            if (RelationType.isRelationSingleValued((RelationType)mmd.getRelationType(clr))) {
                if (!(value instanceof JSONObject)) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " is a persistable field so should have been provided with JSONObject, but is " + StringUtils.toJVMIDString((Object)value));
                }
                JSONObject jsonobj = (JSONObject)value;
                String fieldType = mmd.getTypeName();
                if (jsonobj.has("class")) {
                    fieldType = jsonobj.getString("class");
                }
                if (this.op != null) {
                    this.op.makeDirty(position);
                }
                return RESTUtils.getObjectFromJSONObject((JSONObject)value, fieldType, this.ec);
            }
            if (mmd.hasCollection()) {
                Collection coll;
                if (!(value instanceof JSONArray)) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " is a collection field so should have been provided with JSONArray, but is " + StringUtils.toJVMIDString((Object)value));
                }
                JSONArray array = (JSONArray)value;
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                    coll = (Collection)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException("Exception creating container for field " + mmd.getFullFieldName(), (Throwable)e);
                }
                AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr, this.ec.getMetaDataManager());
                Class elemCls = clr.classForName(mmd.getCollection().getElementType());
                for (int i = 0; i < array.length(); ++i) {
                    if (array.isNull(i)) {
                        coll.add(null);
                        continue;
                    }
                    Object elemValue = array.get(i);
                    if (elemCmd != null) {
                        JSONObject jsonobj = (JSONObject)elemValue;
                        String elemType = mmd.getCollection().getElementType();
                        if (jsonobj.has("class")) {
                            elemType = jsonobj.getString("class");
                        }
                        coll.add(RESTUtils.getObjectFromJSONObject((JSONObject)elemValue, elemType, this.ec));
                        continue;
                    }
                    coll.add(TypeConversionHelper.convertTo((Object)elemValue, (Class)elemCls));
                }
                if (this.op != null) {
                    this.op.makeDirty(position);
                }
                return coll;
            }
            if (mmd.hasArray()) {
                if (!(value instanceof JSONArray)) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " is an array field so should have been provided with JSONArray, but is " + StringUtils.toJVMIDString((Object)value));
                }
                JSONArray array = (JSONArray)value;
                Object arr = Array.newInstance(mmd.getType().getComponentType(), array.length());
                AbstractClassMetaData elemCmd = mmd.getArray().getElementClassMetaData(clr, this.ec.getMetaDataManager());
                Class elemCls = clr.classForName(mmd.getCollection().getElementType());
                for (int i = 0; i < array.length(); ++i) {
                    if (array.isNull(i)) {
                        Array.set(arr, i, null);
                        continue;
                    }
                    Object elemValue = array.get(i);
                    if (elemCmd != null) {
                        JSONObject jsonobj = (JSONObject)elemValue;
                        String elemType = mmd.getArray().getElementType();
                        if (jsonobj.has("class")) {
                            elemType = jsonobj.getString("class");
                        }
                        Array.set(arr, i, RESTUtils.getObjectFromJSONObject((JSONObject)elemValue, elemType, this.ec));
                        continue;
                    }
                    Array.set(arr, i, TypeConversionHelper.convertTo((Object)elemValue, (Class)elemCls));
                }
                if (this.op != null) {
                    this.op.makeDirty(position);
                }
                return arr;
            }
            if (mmd.hasMap()) {
                Map map;
                if (!(value instanceof JSONObject)) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " is a map field so should have been provided with JSONObject, but is " + StringUtils.toJVMIDString((Object)value));
                }
                JSONObject jsonobj = (JSONObject)value;
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)false);
                    map = (Map)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr, this.ec.getMetaDataManager());
                AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr, this.ec.getMetaDataManager());
                Class keyCls = clr.classForName(mmd.getMap().getKeyType());
                Class valCls = clr.classForName(mmd.getMap().getValueType());
                Iterator keyIter = jsonobj.keys();
                while (keyIter.hasNext()) {
                    Object jsonKey = keyIter.next();
                    Object key = null;
                    if (keyCmd != null) {
                        JSONObject keyObj = (JSONObject)jsonKey;
                        String keyType = mmd.getMap().getKeyType();
                        if (jsonobj.has("class")) {
                            keyType = jsonobj.getString("class");
                        }
                        key = RESTUtils.getObjectFromJSONObject(keyObj, keyType, this.ec);
                    } else {
                        key = TypeConversionHelper.convertTo(jsonKey, (Class)keyCls);
                    }
                    Object jsonVal = jsonobj.get((String)jsonKey);
                    Object val = null;
                    if (valCmd != null) {
                        JSONObject valObj = (JSONObject)jsonVal;
                        String valType = mmd.getMap().getValueType();
                        if (jsonobj.has("class")) {
                            valType = jsonobj.getString("class");
                        }
                        val = RESTUtils.getObjectFromJSONObject(valObj, valType, this.ec);
                    } else {
                        val = TypeConversionHelper.convertTo((Object)jsonVal, (Class)valCls);
                    }
                    map.put(key, val);
                }
                if (this.op != null) {
                    this.op.makeDirty(position);
                }
                return map;
            }
            if (value instanceof JSONObject) {
                JSONObject jsonobj = (JSONObject)value;
                String fieldType = mmd.getTypeName();
                if (jsonobj.has("class")) {
                    fieldType = jsonobj.getString("class");
                }
                if (this.op != null) {
                    this.op.makeDirty(position);
                }
                return RESTUtils.getNonPersistableObjectFromJSONObject(jsonobj, clr.classForName(fieldType, true), (NucleusContext)this.ec.getNucleusContext());
            }
            if (this.op != null) {
                this.op.makeDirty(position);
            }
            return TypeConversionHelper.convertTo((Object)value, (Class)this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getType());
        }
        catch (JSONException ex) {
            NucleusLogger.GENERAL.error((Object)("Exception thrown processing field " + mmd.getFullFieldName()), (Throwable)ex);
            throw new NucleusException("Exception thrown processing field " + mmd.getFullFieldName(), (Throwable)ex);
        }
    }
}

