/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.rest.fieldmanager;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.rest.RESTUtils;
import org.datanucleus.api.rest.orgjson.JSONArray;
import org.datanucleus.api.rest.orgjson.JSONException;
import org.datanucleus.api.rest.orgjson.JSONObject;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;

public class ToJSONFieldManager
extends AbstractFieldManager {
    JSONObject jsonobj;
    AbstractClassMetaData cmd;
    ExecutionContext ec;

    public ToJSONFieldManager(JSONObject jsonobj, AbstractClassMetaData cmd, ExecutionContext ec) {
        this.jsonobj = jsonobj;
        this.ec = ec;
        this.cmd = cmd;
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        try {
            this.jsonobj.put(mmd.getName(), value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void storeByteField(int fieldNumber, byte value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        try {
            this.jsonobj.put(mmd.getName(), value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void storeCharField(int fieldNumber, char value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        try {
            this.jsonobj.put(mmd.getName(), value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void storeDoubleField(int fieldNumber, double value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        try {
            this.jsonobj.put(mmd.getName(), value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void storeFloatField(int fieldNumber, float value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        try {
            this.jsonobj.put(mmd.getName(), value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void storeIntField(int fieldNumber, int value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        try {
            this.jsonobj.put(mmd.getName(), value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void storeLongField(int fieldNumber, long value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        try {
            this.jsonobj.put(mmd.getName(), value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void storeShortField(int fieldNumber, short value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        try {
            this.jsonobj.put(mmd.getName(), value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void storeStringField(int fieldNumber, String value) {
        if (value == null) {
            return;
        }
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        try {
            this.jsonobj.put(mmd.getName(), value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void storeObjectField(int fieldNumber, Object value) {
        if (value == null) {
            return;
        }
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        RelationType relationType = mmd.getRelationType(clr);
        try {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                JSONObject obj = RESTUtils.getJSONObjectFromPOJO(value, this.ec);
                this.jsonobj.put(mmd.getName(), obj);
            } else if (mmd.hasCollection()) {
                AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr, this.ec.getMetaDataManager());
                JSONArray arr = new JSONArray();
                Collection collVal = (Collection)value;
                int i = 0;
                for (Object elem : collVal) {
                    if (elemCmd != null) {
                        arr.put(i++, RESTUtils.getJSONObjectFromPOJO(elem, this.ec));
                        continue;
                    }
                    arr.put(i++, elem);
                }
                this.jsonobj.put(mmd.getName(), arr);
            } else if (mmd.hasArray()) {
                AbstractClassMetaData elemCmd = mmd.getArray().getElementClassMetaData(clr, this.ec.getMetaDataManager());
                JSONArray arr = new JSONArray();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object elem = Array.get(value, i);
                    if (elemCmd != null) {
                        arr.put(i++, RESTUtils.getJSONObjectFromPOJO(elem, this.ec));
                        continue;
                    }
                    arr.put(i++, elem);
                }
                this.jsonobj.put(mmd.getName(), arr);
            } else if (mmd.hasMap()) {
                AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr, this.ec.getMetaDataManager());
                AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr, this.ec.getMetaDataManager());
                HashMap<JSONObject, JSONObject> jsonMap = new HashMap<JSONObject, JSONObject>();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    JSONObject key = null;
                    JSONObject val = null;
                    key = keyCmd != null ? RESTUtils.getJSONObjectFromPOJO(entry.getKey(), this.ec) : (JSONObject)entry.getKey();
                    val = valCmd != null ? RESTUtils.getJSONObjectFromPOJO(entry.getValue(), this.ec) : (JSONObject)entry.getValue();
                    jsonMap.put(key, val);
                }
                this.jsonobj.put(mmd.getName(), jsonMap);
            } else {
                this.jsonobj.put(mmd.getName(), value);
            }
        }
        catch (JSONException jsone) {
            throw new NucleusException("Exception converting value of field " + mmd.getFullFieldName() + " to JSON", (Throwable)jsone);
        }
    }
}

