/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.rest;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.api.rest.DummyStateManager;
import org.datanucleus.api.rest.RestServlet;
import org.datanucleus.api.rest.fieldmanager.FromJSONFieldManager;
import org.datanucleus.api.rest.fieldmanager.ToJSONFieldManager;
import org.datanucleus.api.rest.jsonobject.GoogleAppEngineKeyHandler;
import org.datanucleus.api.rest.jsonobject.GoogleAppEngineUserHandler;
import org.datanucleus.api.rest.jsonobject.UserTypeJSONHandler;
import org.datanucleus.api.rest.orgjson.JSONArray;
import org.datanucleus.api.rest.orgjson.JSONException;
import org.datanucleus.api.rest.orgjson.JSONObject;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.TypeConversionHelper;

public class RESTUtils {
    private static Map<String, UserTypeJSONHandler> userClassHandlers = new ConcurrentHashMap<String, UserTypeJSONHandler>();

    public static JSONArray getJSONArrayFromCollection(Collection coll, ExecutionContext ec) {
        JSONArray arr = new JSONArray();
        int i = 0;
        for (Object elem : coll) {
            try {
                arr.put(i++, RESTUtils.getJSONObjectFromPOJO(elem, ec));
            }
            catch (JSONException jSONException) {}
        }
        return arr;
    }

    public static JSONObject getJSONObjectFromPOJO(Object obj, ExecutionContext ec) {
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(obj.getClass(), clr);
        JSONObject jsonobj = new JSONObject();
        try {
            jsonobj.put("class", cmd.getFullClassName());
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                jsonobj.put("_id", IdentityUtils.getTargetKeyForDatastoreIdentity((Object)ec.getApiAdapter().getIdForObject(obj)));
            }
            if (ec.getApiAdapter().getVersionForObject(obj) != null) {
                jsonobj.put("_version", ec.getApiAdapter().getVersionForObject(obj));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        ObjectProvider op = ec.findObjectProvider(obj);
        ToJSONFieldManager fm = new ToJSONFieldManager(jsonobj, cmd, ec);
        op.provideFields(ec.getFetchPlan().getFetchPlanForClass(cmd).getMemberNumbers(), (FieldManager)fm);
        return jsonobj;
    }

    public static Object getObjectFromJSONObject(JSONObject jsonobj, String className, ExecutionContext ec) {
        FromJSONFieldManager fm2;
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForEntityName(className);
        Class cls = null;
        if (cmd != null) {
            cls = clr.classForName(cmd.getFullClassName(), true);
        } else {
            cls = clr.classForName(className, true);
            cmd = ec.getMetaDataManager().getMetaDataForClass(cls, clr);
        }
        if (cmd == null) {
            return RESTUtils.getNonPersistableObjectFromJSONObject(jsonobj, cls, (NucleusContext)ec.getNucleusContext());
        }
        Object id = null;
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            fm2 = new FromJSONFieldManager(jsonobj, cmd, ec);
            try {
                id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, (Class)cls, (boolean)false, (FieldManager)fm2);
            }
            catch (NucleusException nucleusException) {}
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            try {
                id = MetaDataUtils.getTypeOfDatastoreIdentity((IdentityMetaData)cmd.getBaseIdentityMetaData()) == String.class ? ec.getNucleusContext().getIdentityManager().getDatastoreId(className, (Object)jsonobj.getString("_id")) : ec.getNucleusContext().getIdentityManager().getDatastoreId(className, (Object)jsonobj.getLong("_id"));
            }
            catch (JSONException fm2) {
                // empty catch block
            }
        }
        if (id != null) {
            try {
                Object pc = ec.findObject(id, true, false, cmd.getFullClassName());
                ObjectProvider pcOP = ec.findObjectProvider(pc);
                FromJSONFieldManager fm2 = new FromJSONFieldManager(jsonobj, cmd, pcOP);
                pcOP.replaceFields(cmd.getAllMemberPositions(), (FieldManager)fm2);
                return pc;
            }
            catch (NucleusException ne) {
                FromJSONFieldManager fm3 = new FromJSONFieldManager(jsonobj, cmd, ec);
                DummyStateManager dummySM = new DummyStateManager(cls);
                dummySM.replaceFields(cmd.getAllMemberPositions(), (FieldManager)fm3);
                Object pc = dummySM.getObject();
                dummySM.disconnect();
                return pc;
            }
        }
        fm2 = new FromJSONFieldManager(jsonobj, cmd, ec);
        DummyStateManager dummySM = new DummyStateManager(cls);
        dummySM.replaceFields(cmd.getAllMemberPositions(), (FieldManager)fm2);
        Object pc = dummySM.getObject();
        dummySM.disconnect();
        return pc;
    }

    public static Object getIdentityForURLToken(AbstractClassMetaData cmd, String token, PersistenceNucleusContext nucCtx) {
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            ClassLoaderResolver clr = nucCtx.getClassLoaderResolver(RestServlet.class.getClassLoader());
            if (cmd.usesSingleFieldIdentityClass()) {
                Object value = TypeConversionHelper.convertTo((Object)token, (Class)cmd.getMetaDataForManagedMemberAtAbsolutePosition(cmd.getPKMemberPositions()[0]).getType());
                return nucCtx.getIdentityManager().getSingleFieldId(clr.classForName(cmd.getObjectidClass()), clr.classForName(cmd.getFullClassName()), value);
            }
            return nucCtx.getIdentityManager().getApplicationId(clr, cmd, token);
        }
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            Object value = TypeConversionHelper.convertTo((Object)token, (Class)MetaDataUtils.getTypeOfDatastoreIdentity((IdentityMetaData)cmd.getBaseIdentityMetaData()));
            return nucCtx.getIdentityManager().getDatastoreId(cmd.getFullClassName(), value);
        }
        return null;
    }

    public static Object getNonPersistableObjectFromJSONObject(final JSONObject jsonobj, final Class cls, NucleusContext nucCtx) {
        UserTypeJSONHandler handler = userClassHandlers.get(cls.getName());
        if (cls.getName().equals("com.google.appengine.api.users.User")) {
            handler = new GoogleAppEngineUserHandler();
            userClassHandlers.put(cls.getName(), handler);
        } else if (cls.getName().equals("com.google.appengine.api.datastore.Key")) {
            handler = new GoogleAppEngineKeyHandler();
            userClassHandlers.put(cls.getName(), handler);
        }
        if (handler != null) {
            return handler.fromJSON(jsonobj, nucCtx);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Constructor c = ClassUtils.getConstructorWithArguments((Class)cls, (Class[])new Class[0]);
                        c.setAccessible(true);
                        Object obj = c.newInstance(new Object[0]);
                        String[] fieldNames = JSONObject.getNames(jsonobj);
                        for (int i = 0; i < jsonobj.length(); ++i) {
                            if (fieldNames[i].equals("class")) continue;
                            Field field = cls.getField(fieldNames[i]);
                            field.setAccessible(true);
                            field.set(obj, jsonobj.get(fieldNames[i]));
                        }
                        return obj;
                    }
                    catch (Exception e) {
                        NucleusLogger.GENERAL.error((Object)"Exception in conversion from JSONObject field to value", (Throwable)e);
                        return null;
                    }
                }
            });
        }
        catch (SecurityException ex) {
            NucleusLogger.DATASTORE_RETRIEVE.warn((Object)"Exception in construction of object from JSON", (Throwable)ex);
            return null;
        }
    }
}

