/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.java8.converters;

import java.sql.Time;
import java.time.LocalTime;
import java.util.Calendar;
import org.datanucleus.store.types.converters.TypeConverter;

public class LocalTimeSqlTimeConverter
implements TypeConverter<LocalTime, Time> {
    private static final long serialVersionUID = -792979141879966844L;

    public LocalTime toMemberType(Time time) {
        if (time == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        return LocalTime.of(cal.get(11), cal.get(12), cal.get(13), cal.get(14) * 1000000);
    }

    public Time toDatastoreType(LocalTime time) {
        if (time == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(0, 0, 0, time.getHour(), time.getMinute(), time.getSecond());
        cal.set(14, time.getNano() / 1000000);
        return new Time(cal.getTimeInMillis());
    }
}

