/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jpa;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.jpa.EntityManagerFactoryImpl;
import org.datanucleus.store.StoreManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class JPAReplicationManager {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.jpa.Localisation", (ClassLoader)EntityManagerFactoryImpl.class.getClassLoader());
    final EntityManagerFactory emfSource;
    final EntityManagerFactory emfTarget;
    protected Properties properties = new Properties();

    public JPAReplicationManager(EntityManagerFactory emf1, EntityManagerFactory emf2) {
        if (emf1 == null || !emf1.isOpen()) {
            throw new NucleusException(LOCALISER.msg("012050"));
        }
        if (emf2 == null || !emf2.isOpen()) {
            throw new NucleusException(LOCALISER.msg("012050"));
        }
        this.emfSource = emf1;
        this.emfTarget = emf2;
        this.properties.setProperty("datanucleus.replicateObjectGraph", "true");
        this.properties.setProperty("datanucleus.deleteUnknownObjects", "false");
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public Properties getProperties() {
        return this.properties;
    }

    protected boolean getBooleanProperty(String key) {
        String val = this.properties.getProperty(key);
        if (val == null) {
            return false;
        }
        return val.equalsIgnoreCase("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicate(Class ... types) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("012052", (Object)this.emfSource, (Object)this.emfTarget, (Object)StringUtils.objectArrayToString((Object[])types)));
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("012053"));
        }
        EntityManager em1 = this.emfSource.createEntityManager();
        EntityTransaction tx1 = em1.getTransaction();
        if (this.getBooleanProperty("datanucleus.replicateObjectGraph")) {
            ObjectManager om = (ObjectManager)em1.getDelegate();
            om.getFetchPlan().setGroup("all");
            om.getFetchPlan().setMaxFetchDepth(-1);
        }
        ArrayList objects = new ArrayList();
        try {
            tx1.begin();
            for (int i = 0; i < types.length; ++i) {
                List results = em1.createQuery("SELECT Object(T) FROM " + types[i].getName() + " T").getResultList();
                objects.addAll(results);
            }
            tx1.commit();
        }
        finally {
            if (tx1.isActive()) {
                tx1.rollback();
            }
            em1.close();
        }
        this.replicateInTarget(objects.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicate(String ... classNames) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("012052", (Object)this.emfSource, (Object)this.emfTarget, (Object)StringUtils.objectArrayToString((Object[])classNames)));
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("012053"));
        }
        EntityManager em1 = this.emfSource.createEntityManager();
        EntityTransaction tx1 = em1.getTransaction();
        if (this.getBooleanProperty("datanucleus.replicateObjectGraph")) {
            ObjectManager om = (ObjectManager)em1.getDelegate();
            om.getFetchPlan().setGroup("all");
            om.getFetchPlan().setMaxFetchDepth(-1);
        }
        ArrayList objects = new ArrayList();
        try {
            tx1.begin();
            for (int i = 0; i < classNames.length; ++i) {
                List results = em1.createQuery("SELECT Object(T) FROM " + classNames[i] + " T").getResultList();
                objects.addAll(results);
            }
            tx1.commit();
        }
        finally {
            if (tx1.isActive()) {
                tx1.rollback();
            }
            em1.close();
        }
        this.replicateInTarget(objects.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicate(Object ... oids) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("012051", (Object)this.emfSource, (Object)this.emfTarget, (Object)StringUtils.objectArrayToString((Object[])oids)));
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("012053"));
        }
        EntityManager em1 = this.emfSource.createEntityManager();
        EntityTransaction tx1 = em1.getTransaction();
        ObjectManager om = (ObjectManager)em1.getDelegate();
        if (this.getBooleanProperty("datanucleus.replicateObjectGraph")) {
            om.getFetchPlan().setGroup("all");
            om.getFetchPlan().setMaxFetchDepth(-1);
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        StoreManager storeMgr = om.getStoreManager();
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        try {
            tx1.begin();
            for (int i = 0; i < oids.length; ++i) {
                try {
                    String className = storeMgr.getClassNameForObjectID(oids[i], clr, om);
                    if (className == null) {
                        throw new NucleusException("Unable to find the class name for the identity " + oids[i]);
                    }
                    Class cls = clr.classForName(className);
                    Object obj = em1.find(cls, oids[i]);
                    objects.add(obj);
                    continue;
                }
                catch (ClassNotResolvedException cnre) {
                    throw new NucleusException("Object with id " + oids[i] + " threw exception when determing class name", (Throwable)cnre);
                }
            }
            tx1.commit();
        }
        finally {
            if (tx1.isActive()) {
                tx1.rollback();
            }
            em1.close();
        }
        this.replicateInTarget(objects.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replicateInTarget(Object ... detachedObjects) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("012054"));
        }
        EntityManager em2 = this.emfTarget.createEntityManager();
        EntityTransaction tx2 = em2.getTransaction();
        ObjectManager om2 = (ObjectManager)em2.getDelegate();
        om2.setAttachPolicy("attach-all");
        try {
            tx2.begin();
            em2.merge((Object)detachedObjects);
            tx2.commit();
        }
        finally {
            if (tx2.isActive()) {
                tx2.rollback();
            }
            em2.close();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("012055"));
        }
    }
}

