/**********************************************************************
Copyright (c) 2007 Erik Bengtson and others. All rights reserved. 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 
 

Contributors:
    ...
**********************************************************************/

package org.datanucleus.store.rdbms.query.legacy;

import java.text.CharacterIterator;

import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.util.Imports;

/**
 * Parser for JPQL queries, extending the basic JDOQL parser for supporting the identifier ?1, ?2 syntax.
 * 
 * @version $Revision: 1.2 $
 */
public class JPQLParser extends Parser
{
    /**
     * Constructor.
     * @param input Input string
     * @param imports Any imports
     */
    public JPQLParser(String input, Imports imports)
    {
        super(input, imports);
    }

    /**
     * Override the identifier parse to allow for ?1, ?2 syntax
     * @return The identifier
     */
    public String parseIdentifier()
    {
        String identifier = super.parseIdentifier();
        if (identifier != null)
        {
            return identifier;
        }
        skipWS();
        char c = ci.current();

        if (!Character.isJavaIdentifierStart(c) && !(c == '?'))
        {
            // Current character is not a valid identifier char, and isn't a
            // valid JDOQL parameter start character
            return null;
        }

        StringBuffer id = new StringBuffer();
        id.append(c);
        while (Character.isJavaIdentifierPart(c = ci.next()))
        {
            id.append(c);
        }

        return id.toString();
    }

    /**
     * Parse a Character literal.
     * @return the Character parsed. null if single quotes is found
     * @throws NucleusUserException if an invalid character is found or the CharacterIterator is finished
     */
    public Character parseCharacterLiteral()
    {
        skipWS();

        if (ci.current() != '\'')
        {
            return null;
        }

        char c = ci.next();

        if (c == CharacterIterator.DONE)
        {
            throw new NucleusUserException("Invalid character literal: " + input);
        }

        if (ci.next() != '\'')
        {
            throw new NucleusUserException("Invalid character literal: " + input);
        }

        ci.next();

        return new Character(c);
    }

    /**
     * Parse a String literal.
     * @return the String parsed. null if single quotes or double quotes is found
     * @throws NucleusUserException if an invalid character is found or the CharacterIterator is finished
     */
    public String parseStringLiteral()
    {
        skipWS();

        // Strings can be surrounded by single or double quotes
        char quote = ci.current();
        if (quote != '"' && quote != '\'')
        {
            return null;
        }

        StringBuffer lit = new StringBuffer();
        char c;

        while ((c = ci.next()) != quote)
        {
            if (c == CharacterIterator.DONE)
            {
                throw new NucleusUserException("Invalid string literal: " + input);
            }

            lit.append(c);
        }

        ci.next();

        return lit.toString();
    }
}