/**********************************************************************
Copyright (c) 2004 Erik Bengtson and others. All rights reserved. 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 
 

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.rdbms.request;

import org.datanucleus.store.mapped.StatementMappingIndex;

/**
 * Holder for the StatementExpressionIndex for datastore id, PKs, version, and fields mappings.
 * Effectively provides the lookup of StatementExpressionINdex for the different mapping of a
 * request statement.
 */
class StatementMappingDefinition
{
    private StatementMappingIndex datastoreId;
    private StatementMappingIndex[] primaryKeys;

    private StatementMappingIndex[] fields;

    private StatementMappingIndex version;
    private StatementMappingIndex version2;
    
    /**
     * Accessor for the datastore id mapping index.
     * @return Returns the datastoreId.
     */
    public StatementMappingIndex getDatastoreId()
    {
        return datastoreId;
    }

    /**
     * Mutator for the datastore id mapping index.
     * @param datastoreId The datastoreId to set.
     */
    public void setDatastoreId(StatementMappingIndex datastoreId)
    {
        this.datastoreId = datastoreId;
    }

    /**
     * Accessor for the version mapping index.
     * @return Returns the version index.
     */
    public StatementMappingIndex getVersion()
    {
        return version;
    }

    /**
     * Mutator for the version mapping index.
     * @param ver The version to set.
     */
    public void setVersion(StatementMappingIndex ver)
    {
        this.version = ver;
    }

    /**
     * Accessor for the second version mapping index.
     * @return Returns the version index.
     */
    public StatementMappingIndex getVersion2()
    {
        return version2;
    }

    /**
     * Accessor for the second version mapping index.
     * @param ver The version to set.
     */
    public void setVersion2(StatementMappingIndex ver)
    {
        this.version2 = ver;
    }

    /**
     * Accessor for the mapping indices for the fields.
     * @return Returns the fields.
     */
    public StatementMappingIndex[] getFields()
    {
        return fields;
    }

    /**
     * Mutator for the mapping indices for the fields.
     * @param fields The fields to set.
     */
    public void setFields(StatementMappingIndex[] fields)
    {
        this.fields = fields;
    }

    /**
     * Accessor for the primary key mapping indices for the fields.
     * @return Returns the primaryKeys.
     */
    public StatementMappingIndex[] getPrimaryKeys()
    {
        return primaryKeys;
    }

    /**
     * Mutator for the primary key mapping indices for the fields.
     * @param primaryKeys The primaryKeys to set.
     */
    public void setPrimaryKeys(StatementMappingIndex[] primaryKeys)
    {
        this.primaryKeys = primaryKeys;
    }
}