/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.List;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;

public class BooleanExpression
extends SQLExpression {
    public BooleanExpression(SQLStatement stmt, JavaTypeMapping mapping, String sql) {
        super(stmt, null, mapping);
        this.st.clearStatement();
        this.st.append(sql);
    }

    public BooleanExpression(SQLStatement stmt, SQLTable table, JavaTypeMapping mapping) {
        super(stmt, table, mapping);
    }

    public BooleanExpression(Expression.MonadicOperator op, SQLExpression expr1) {
        super(op, expr1);
    }

    public BooleanExpression(SQLExpression expr1, Expression.DyadicOperator op, SQLExpression expr2) {
        super(expr1, op, expr2);
    }

    public BooleanExpression and(SQLExpression expr) {
        if (expr instanceof BooleanLiteral) {
            return expr.and(this);
        }
        if (expr instanceof BooleanExpression) {
            return new BooleanExpression(this, Expression.OP_AND, expr);
        }
        return super.and(expr);
    }

    public BooleanExpression eor(SQLExpression expr) {
        if (expr instanceof BooleanLiteral) {
            return expr.eor(this);
        }
        if (expr instanceof BooleanExpression) {
            if (this.stmt.getDatabaseAdapter().supportsOption("BooleanExpression")) {
                return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
            }
            return this.and(expr.not()).ior(this.not().and(expr));
        }
        return super.eor(expr);
    }

    public BooleanExpression ior(SQLExpression expr) {
        if (expr instanceof BooleanLiteral) {
            return expr.ior(this);
        }
        if (expr instanceof BooleanExpression) {
            return new BooleanExpression(this, Expression.OP_OR, expr);
        }
        return super.ior(expr);
    }

    public BooleanExpression not() {
        return new BooleanExpression(Expression.OP_NOT, this);
    }

    public BooleanExpression eq(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof BooleanLiteral || expr instanceof NullLiteral) {
            return expr.eq(this);
        }
        if (expr instanceof BooleanExpression) {
            DatastoreMapping datastoreMapping = this.mapping.getDatastoreMapping(0);
            if (datastoreMapping.isStringBased()) {
                return new BooleanExpression(new NumericExpression(this.stmt, this.table, this.mapping), Expression.OP_EQ, new NumericExpression(this.stmt, expr.table, expr.mapping));
            }
            if ((datastoreMapping.isBitBased() || datastoreMapping.isIntegerBased()) && !this.stmt.getDatabaseAdapter().supportsOption("BitIsReallyBoolean")) {
                return new BooleanExpression(new CharacterExpression(this.stmt, this.table, this.mapping), Expression.OP_EQ, new CharacterExpression(this.stmt, expr.table, expr.mapping));
            }
            if (this.stmt.getDatabaseAdapter().supportsOption("BooleanExpression")) {
                return new BooleanExpression(this, Expression.OP_EQ, expr);
            }
            return this.and(expr).ior(this.not().and(expr.not()));
        }
        return super.eq(expr);
    }

    public BooleanExpression ne(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof BooleanLiteral || expr instanceof NullLiteral) {
            return expr.ne(this);
        }
        if (expr instanceof BooleanExpression) {
            DatastoreMapping datastoreMapping = this.mapping.getDatastoreMapping(0);
            if (datastoreMapping.isStringBased()) {
                return new BooleanExpression(new CharacterExpression(this.stmt, this.table, this.mapping), Expression.OP_NOTEQ, new CharacterExpression(this.stmt, expr.table, expr.mapping));
            }
            if ((datastoreMapping.isBitBased() || datastoreMapping.isIntegerBased()) && !this.stmt.getDatabaseAdapter().supportsOption("BitIsReallyBoolean")) {
                return new BooleanExpression(new NumericExpression(this.stmt, this.table, this.mapping), Expression.OP_NOTEQ, new NumericExpression(this.stmt, expr.table, expr.mapping));
            }
            if (this.stmt.getDatabaseAdapter().supportsOption("BooleanExpression")) {
                return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
            }
            return this.and(expr.not()).ior(this.not().and(expr));
        }
        return super.ne(expr);
    }

    public BooleanExpression in(SQLExpression expr) {
        DatastoreMapping datastoreMapping = this.mapping.getDatastoreMapping(0);
        if (datastoreMapping.isStringBased()) {
            return new BooleanExpression(new CharacterExpression(this.stmt, this.table, this.mapping), Expression.OP_IN, expr);
        }
        return new BooleanExpression(this, Expression.OP_IN, expr);
    }

    public SQLExpression invoke(String methodName, List args) {
        return this.stmt.getRDBMSManager().getSQLExpressionFactory().invokeMethod(this.stmt, Boolean.class.getName(), methodName, this, args);
    }

    public BooleanExpression neg() {
        return new BooleanExpression(Expression.OP_NEG, this);
    }
}

