/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.datasource;

import java.util.Properties;
import javax.sql.DataSource;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.datasource.AbstractDataSourceFactory;
import org.datanucleus.store.rdbms.datasource.DataNucleusDataSourceFactory;
import org.datanucleus.store.rdbms.datasource.DatastorePoolException;
import org.datanucleus.util.ClassUtils;
import org.logicalcobwebs.proxool.ProxoolDataSource;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;

public class ProxoolDataSourceFactory
extends AbstractDataSourceFactory
implements DataNucleusDataSourceFactory {
    private static int poolNumber = 0;

    public DataSource makePooledDataSource(StoreManager storeMgr) {
        String dbPassword;
        String dbDriver = storeMgr.getConnectionDriverName();
        String dbURL = storeMgr.getConnectionURL();
        String dbUser = storeMgr.getConnectionUserName();
        if (dbUser == null) {
            dbUser = "";
        }
        if ((dbPassword = storeMgr.getConnectionPassword()) == null) {
            dbPassword = "";
        }
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        this.loadDriver(dbDriver, clr);
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"org.apache.commons.logging.Log", (String)"commons-logging.jar");
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"org.logicalcobwebs.proxool.ProxoolDriver", (String)"proxool.jar");
        String alias = "datanucleus" + poolNumber;
        try {
            Properties props = new Properties();
            if (storeMgr.hasProperty("datanucleus.connectionPool.maxConnections")) {
                int value = storeMgr.getIntProperty("datanucleus.connectionPool.maxConnections");
                if (value > 0) {
                    props.put("proxool.maximum-connection-count", "" + value);
                } else {
                    props.put("proxool.maximum-connection-count", "10");
                }
            } else {
                props.put("proxool.maximum-connection-count", "10");
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.testSQL")) {
                String value = storeMgr.getStringProperty("datanucleus.connectionPool.testSQL");
                props.put("proxool.house-keeping-test-sql", value);
            } else {
                props.put("proxool.house-keeping-test-sql", "SELECT 1");
            }
            props.setProperty("user", dbUser);
            props.setProperty("password", dbPassword);
            String url = "proxool." + alias + ":" + dbDriver + ":" + dbURL;
            ++poolNumber;
            ProxoolFacade.registerConnectionPool((String)url, (Properties)props);
        }
        catch (ProxoolException pe) {
            pe.printStackTrace();
            throw new DatastorePoolException("Proxool", dbDriver, dbURL, (Exception)((Object)pe));
        }
        ProxoolDataSource ds = new ProxoolDataSource(alias);
        return ds;
    }
}

