/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMapping;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.TypeConverter;

public class TypeConverterStringMapping
extends SingleFieldMapping {
    TypeConverter converter;

    @Override
    public void initialize(RDBMSStoreManager storeMgr, String type) {
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        Class fieldType = clr.classForName(type);
        this.converter = storeMgr.getNucleusContext().getTypeManager().getDefaultTypeConverterForType(fieldType);
        Class datastoreType = TypeManager.getDatastoreTypeForTypeConverter((TypeConverter)this.converter, (Class)fieldType);
        if (!String.class.isAssignableFrom(datastoreType)) {
            throw new NucleusException("Attempt to create TypeConverterStringMapping for type " + type + " yet this is not using String in the datastore");
        }
        super.initialize(storeMgr, type);
    }

    @Override
    public void initialize(AbstractMemberMetaData fmd, Table table, ClassLoaderResolver clr) {
        if (fmd.getTypeConverterName() != null) {
            this.converter = table.getStoreManager().getNucleusContext().getTypeManager().getTypeConverterForName(fmd.getTypeConverterName());
        } else {
            this.converter = table.getStoreManager().getNucleusContext().getTypeManager().getDefaultTypeConverterForType(fmd.getType());
            if (this.converter == null) {
                throw new NucleusException("Attempt to create TypeConverterStringMapping when no type converter defined for member " + fmd.getFullFieldName());
            }
        }
        Class datastoreType = TypeManager.getDatastoreTypeForTypeConverter((TypeConverter)this.converter, (Class)fmd.getType());
        if (!String.class.isAssignableFrom(datastoreType)) {
            throw new NucleusException("Attempt to create TypeConverterStringMapping for member " + fmd.getFullFieldName() + " yet this is not using String in the datastore");
        }
        super.initialize(fmd, table, clr);
    }

    @Override
    public String getJavaTypeForDatastoreMapping(int index) {
        return String.class.getName();
    }

    @Override
    public Class getJavaType() {
        return TypeManager.getMemberTypeForTypeConverter((TypeConverter)this.converter, String.class);
    }

    @Override
    public void setString(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, String value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setString(ps, exprIndex[0], (String)this.converter.toDatastoreType((Object)value));
    }

    @Override
    public String getString(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return null;
        }
        String datastoreValue = this.getDatastoreMapping(0).getString(resultSet, exprIndex[0]);
        return datastoreValue != null ? (String)this.converter.toMemberType((Object)datastoreValue) : null;
    }

    @Override
    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setObject(ps, exprIndex[0], this.converter.toDatastoreType(value));
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return null;
        }
        Object datastoreValue = this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]);
        return datastoreValue != null ? this.converter.toMemberType(datastoreValue) : null;
    }
}

