/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.aws.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import java.io.File;
import java.io.InputStream;

public abstract class BaseS3 {
    protected static final long serialVersionUID = -2280107690193651289L;
    protected String accessKey;
    protected String secretKey;
    protected AWSCredentials creds;
    public static final String ACCESS_KEY = "org.deeplearning4j.aws.accessKey";
    public static final String ACCESS_SECRET = "org.deeplearning4j.aws.accessSecret";
    public static final String AWS_ACCESS_KEY = "AWS_ACCESS_KEY_ID";
    public static final String AWS_SECRET_KEY = "AWS_SECRET_ACCESS_KEY";

    protected void findCreds() {
        if (System.getProperty(ACCESS_KEY) != null && System.getProperty(ACCESS_SECRET) != null) {
            this.accessKey = System.getProperty(ACCESS_KEY);
            this.secretKey = System.getProperty(ACCESS_SECRET);
        } else if (System.getenv(AWS_ACCESS_KEY) != null && System.getenv(AWS_SECRET_KEY) != null) {
            this.accessKey = System.getenv(AWS_ACCESS_KEY);
            this.secretKey = System.getenv(AWS_SECRET_KEY);
        }
    }

    public BaseS3() {
        this.findCreds();
        if (this.accessKey != null && this.secretKey != null) {
            this.creds = new BasicAWSCredentials(this.accessKey, this.secretKey);
        }
        if (this.creds == null) {
            throw new IllegalStateException("Unable to find ec2 credentials");
        }
    }

    public BaseS3(File file) throws Exception {
        this.creds = this.accessKey != null && this.secretKey != null ? new BasicAWSCredentials(this.accessKey, this.secretKey) : new PropertiesCredentials(file);
    }

    public BaseS3(InputStream is) throws Exception {
        this.creds = this.accessKey != null && this.secretKey != null ? new BasicAWSCredentials(this.accessKey, this.secretKey) : new PropertiesCredentials(is);
    }

    public AWSCredentials getCreds() {
        return this.creds;
    }

    public void setCreds(AWSCredentials creds) {
        this.creds = creds;
    }

    public AmazonS3 getClient() {
        return new AmazonS3Client(this.creds);
    }

    public AmazonEC2 getEc2() {
        return new AmazonEC2Client(this.creds);
    }
}

