/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.sentenceiterator.labelaware;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.resource.ResourceInitializationException;
import org.deeplearning4j.text.annotator.SentenceAnnotator;
import org.deeplearning4j.text.annotator.TokenizerAnnotator;
import org.deeplearning4j.text.sentenceiterator.SentencePreProcessor;
import org.deeplearning4j.text.sentenceiterator.UimaSentenceIterator;
import org.deeplearning4j.text.sentenceiterator.labelaware.LabelAwareSentenceIterator;
import org.deeplearning4j.text.uima.UimaResource;

public class LabelAwareUimaSentenceIterator
extends UimaSentenceIterator
implements LabelAwareSentenceIterator {
    public LabelAwareUimaSentenceIterator(SentencePreProcessor preProcessor, String path, UimaResource resource) {
        super(preProcessor, path, resource);
    }

    public LabelAwareUimaSentenceIterator(String path, AnalysisEngine engine) throws ResourceInitializationException {
        super(path, new UimaResource(engine));
    }

    @Override
    public String currentLabel() {
        try {
            Field f = this.reader.getClass().getDeclaredField("currentFile");
            f.setAccessible(true);
            File file = (File)f.get(this.reader);
            return file.getParentFile().getName();
        }
        catch (NullPointerException e1) {
            return "NONE";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static LabelAwareSentenceIterator createWithPath(String path) throws Exception {
        return new LabelAwareUimaSentenceIterator(null, path, new UimaResource(AnalysisEngineFactory.createEngine((AnalysisEngineDescription)AnalysisEngineFactory.createEngineDescription((AnalysisEngineDescription[])new AnalysisEngineDescription[]{TokenizerAnnotator.getDescription(), SentenceAnnotator.getDescription()}), (Object[])new Object[0])));
    }

    @Override
    public List<String> currentLabels() {
        return Arrays.asList(this.currentLabel());
    }
}

