/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.jee.security.jwt.impl;

import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.demoiselle.jee.core.api.security.DemoiselleUser;
import org.demoiselle.jee.core.api.security.Token;
import org.demoiselle.jee.core.api.security.TokenManager;
import org.demoiselle.jee.core.api.security.TokenType;
import org.demoiselle.jee.security.exception.DemoiselleSecurityException;
import org.demoiselle.jee.security.jwt.impl.DemoiselleSecurityJWTConfig;
import org.demoiselle.jee.security.message.DemoiselleSecurityJWTMessages;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.RsaKeyUtil;
import org.jose4j.lang.JoseException;

@RequestScoped
@Priority(value=2000)
public class TokenManagerImpl
implements TokenManager {
    private static PublicKey publicKey;
    private static PrivateKey privateKey;
    private static final Logger logger;
    @Inject
    private Token token;
    @Inject
    private DemoiselleSecurityJWTConfig config;
    @Inject
    private DemoiselleUser loggedUser;
    @Inject
    private DemoiselleSecurityJWTMessages bundle;

    @PostConstruct
    public void init() {
        if (publicKey == null) {
            try {
                if (this.config.getType() == null) {
                    throw new DemoiselleSecurityException(this.bundle.chooseType(), Response.Status.UNAUTHORIZED.getStatusCode());
                }
                if (!this.config.getType().equalsIgnoreCase(this.bundle.slave()) && !this.config.getType().equalsIgnoreCase(this.bundle.master())) {
                    throw new DemoiselleSecurityException(this.bundle.notType(), Response.Status.UNAUTHORIZED.getStatusCode());
                }
                if (this.config.getType().equalsIgnoreCase(this.bundle.slave())) {
                    if (this.config.getPublicKey() == null || this.config.getPublicKey().isEmpty()) {
                        throw new DemoiselleSecurityException(this.bundle.putKey(), Response.Status.UNAUTHORIZED.getStatusCode());
                    }
                    publicKey = this.getPublic();
                }
                if (this.config.getType().equalsIgnoreCase(this.bundle.master())) {
                    privateKey = this.getPrivate();
                    publicKey = this.getPublic();
                }
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException | JoseException ex) {
                throw new DemoiselleSecurityException(this.bundle.general(), Response.Status.UNAUTHORIZED.getStatusCode(), (Exception)ex);
            }
        }
    }

    public DemoiselleUser getUser() {
        return this.getUser(null, null);
    }

    public DemoiselleUser getUser(String issuer, String audience) {
        if (this.token.getKey() != null && !this.token.getKey().isEmpty() && this.token.getType().equals((Object)TokenType.JWT)) {
            try {
                JwtConsumer jwtConsumer = new JwtConsumerBuilder().setRequireExpirationTime().setAllowedClockSkewInSeconds(60).setExpectedIssuer(issuer != null ? issuer : this.config.getIssuer()).setExpectedAudience(new String[]{audience != null ? audience : this.config.getAudience()}).setEvaluationTime(NumericDate.now()).setVerificationKey((Key)publicKey).build();
                JwtClaims jwtClaims = jwtConsumer.processToClaims(this.token.getKey());
                this.loggedUser.setIdentity((String)jwtClaims.getClaimValue("identity"));
                this.loggedUser.setName((String)jwtClaims.getClaimValue("name"));
                List list = (List)jwtClaims.getClaimValue("roles");
                list.stream().forEach(string -> this.loggedUser.addRole(string));
                Map mappermissions = (Map)jwtClaims.getClaimValue("permissions");
                mappermissions.entrySet().stream().forEach(entry -> {
                    String key = (String)entry.getKey();
                    List value = (List)entry.getValue();
                    value.stream().forEach(string -> this.loggedUser.addPermission(key, string));
                });
                Map mapparams = (Map)jwtClaims.getClaimValue("params");
                mapparams.entrySet().stream().forEach(entry -> this.loggedUser.addParam((String)entry.getKey(), (String)entry.getValue()));
                return this.loggedUser;
            }
            catch (InvalidJwtException ex) {
                this.loggedUser = null;
                this.token.setKey(null);
                throw new DemoiselleSecurityException(this.bundle.expired(), Response.Status.UNAUTHORIZED.getStatusCode(), (Exception)((Object)ex));
            }
        }
        return null;
    }

    public void setUser(DemoiselleUser user) {
        this.setUser(user, null, null);
    }

    public void setUser(DemoiselleUser user, String issuer, String audience) {
        long time = NumericDate.now().getValueInMillis() + this.config.getTimetoLiveMilliseconds();
        try {
            JwtClaims claims = new JwtClaims();
            claims.setIssuer(issuer != null ? issuer : this.config.getIssuer());
            claims.setExpirationTime(NumericDate.fromMilliseconds((long)time));
            claims.setAudience(audience != null ? audience : this.config.getAudience());
            claims.setGeneratedJwtId();
            claims.setIssuedAtToNow();
            claims.setNotBeforeMinutesInThePast(1.0f);
            claims.setClaim("identity", (Object)user.getIdentity());
            claims.setClaim("name", (Object)user.getName());
            claims.setClaim("roles", (Object)user.getRoles());
            claims.setClaim("permissions", (Object)user.getPermissions());
            claims.setClaim("params", (Object)user.getParams());
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(claims.toJson());
            jws.setKey((Key)privateKey);
            jws.setKeyIdHeaderValue("demoiselle-security-jwt");
            jws.setAlgorithmHeaderValue(this.config.getAlgorithmIdentifiers());
            this.token.setKey(jws.getCompactSerialization());
            this.token.setType(TokenType.JWT);
        }
        catch (JoseException ex) {
            throw new DemoiselleSecurityException(this.bundle.general(), Response.Status.UNAUTHORIZED.getStatusCode(), (Exception)((Object)ex));
        }
    }

    public boolean validate() {
        return this.getUser() != null;
    }

    public boolean validate(String issuer, String audience) {
        return this.getUser(issuer, audience) != null;
    }

    private PrivateKey getPrivate() throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (this.config.getPrivateKey() == null) {
            KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance("RSA");
            keyGenerator.initialize(2048);
            KeyPair kp = keyGenerator.genKeyPair();
            publicKey = kp.getPublic();
            privateKey = kp.getPrivate();
            logger.warning("privateKey=" + publicKey.toString());
            logger.warning("publicKey=" + privateKey.toString());
            throw new DemoiselleSecurityException(this.bundle.putKey(), Response.Status.UNAUTHORIZED.getStatusCode());
        }
        byte[] keyBytes = Base64.getDecoder().decode(this.config.getPrivateKey().replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", ""));
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(spec);
    }

    private PublicKey getPublic() throws JoseException, InvalidKeySpecException {
        RsaKeyUtil rsaKeyUtil = new RsaKeyUtil();
        return rsaKeyUtil.fromPemEncoded(this.config.getPublicKey());
    }

    public void removeUser(DemoiselleUser user) {
        throw new UnsupportedOperationException(this.bundle.notJwt());
    }

    static {
        logger = Logger.getLogger(TokenManagerImpl.class.getName());
    }
}

