/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.crl;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import java.math.BigInteger;
import java.util.Date;
import org.bouncycastle.asn1.esf.CrlIdentifier;
import org.bouncycastle.asn1.esf.CrlValidatedID;
import org.bouncycastle.asn1.x500.X500Name;

public final class CRLRef
extends RevocationRef<CRL> {
    private static final long serialVersionUID = -6785644604097791548L;
    private X500Name crlIssuer;
    private Date crlIssuedTime;
    private BigInteger crlNumber;

    public CRLRef(Digest digest) {
        this.digest = digest;
    }

    public CRLRef(CrlValidatedID cmsRef) {
        try {
            CrlIdentifier crlIdentifier = cmsRef.getCrlIdentifier();
            if (crlIdentifier != null) {
                this.crlIssuer = crlIdentifier.getCrlIssuer();
                this.crlIssuedTime = crlIdentifier.getCrlIssuedTime().getDate();
                this.crlNumber = crlIdentifier.getCrlNumber();
            }
            this.digest = DSSRevocationUtils.getDigest(cmsRef.getCrlHash());
        }
        catch (Exception e) {
            throw new DSSException("Unable to build CRLRef from CrlValidatedID", (Throwable)e);
        }
    }

    public X500Name getCrlIssuer() {
        return this.crlIssuer;
    }

    public void setCrlIssuer(X500Name crlIssuer) {
        this.crlIssuer = crlIssuer;
    }

    public Date getCrlIssuedTime() {
        return this.crlIssuedTime;
    }

    public void setCrlIssuedTime(Date crlIssuedTime) {
        this.crlIssuedTime = crlIssuedTime;
    }

    public BigInteger getCrlNumber() {
        return this.crlNumber;
    }

    public void setCrlNumber(BigInteger crlNumber) {
        this.crlNumber = crlNumber;
    }

    @Override
    public String toString() {
        return "CRL Reference with Digest [" + super.toString() + "]";
    }
}

