/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.tsp;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.identifier.IdentifierBuilder;
import eu.europa.esig.dss.spi.x509.tsp.TimestampTokenIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;

public class TimestampIdentifierBuilder
implements IdentifierBuilder {
    private static final long serialVersionUID = 8108224076397826022L;
    protected final byte[] timestampTokenBinaries;
    private String filename;

    public TimestampIdentifierBuilder(byte[] timestampTokenBinaries) {
        Objects.requireNonNull(timestampTokenBinaries, "Timestamp token binaries cannot be null!");
        this.timestampTokenBinaries = timestampTokenBinaries;
    }

    public TimestampIdentifierBuilder setFilename(String filename) {
        this.filename = filename;
        return this;
    }

    public TimestampTokenIdentifier build() {
        return new TimestampTokenIdentifier(this.buildBinaries());
    }

    protected byte[] buildBinaries() {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.writeTimestampBinaries(baos);
            this.writeTimestampPosition(baos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(String.format("An error occurred while building an Identifier : %s", e.getMessage()), (Throwable)e);
            }
        }
        baos.close();
        return byArray;
    }

    protected void writeTimestampBinaries(ByteArrayOutputStream baos) throws IOException {
        baos.write(this.timestampTokenBinaries);
    }

    protected void writeTimestampPosition(ByteArrayOutputStream baos) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(baos);){
            String positionId = this.getUniquePositionId();
            if (positionId != null) {
                dos.writeChars(positionId);
            }
            dos.flush();
        }
    }

    protected String getUniquePositionId() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTimestampPosition());
        if (this.filename != null) {
            stringBuilder.append(this.filename);
        }
        return stringBuilder.toString();
    }

    protected Object getTimestampPosition() {
        return "";
    }
}

