/*
 * Copyright (c) 2003-2006 OFFIS, Henri Tremblay. 
 * This program is made available under the terms of the MIT License.
 */
package org.easymock.classextension.internal;

/**
 * Factory returning a {@link IClassInstantiator}for the current JVM
 */
public class ClassInstantiatorFactory {

    // ///CLOVER:OFF
    private ClassInstantiatorFactory() {
    }

    // ///CLOVER:ON

    /**
     * Returns the current JVM as specified in the Systtem properties
     * 
     * @return current JVM
     */
    public static String getJVM() {
        return System.getProperty("java.vm.specification.vendor");
    }

    /**
     * Returns the current JVM specification version (1.5, 1.4, 1.3)
     * 
     * @return current JVM specification version
     */
    public static String getJVMSpecificationVersion() {
        return System.getProperty("java.specification.version");
    }

    public static boolean isSunJVM() {
        return getJVM().equals("Sun Microsystems Inc.");
    }

    public static boolean is1_3Specifications() {
        return getJVMSpecificationVersion().equals("1.3");
    }

    /**
     * Returns a class instantiator suitable for the current JVM
     * 
     * @return a class instantiator usable on the current JVM
     */
    public static IClassInstantiator getInstantiator() {
        // Sadly, the class extension only works on Sun JVM for JDK 1.4 and
        // above
        if (isSunJVM() && !is1_3Specifications()) {
            return new SunClassInstantiator();
        }
        return new DefaultClassInstantiator();
    }
}
