/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.classextension.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.easymock.classextension.internal.IClassInstantiator;
import sun.reflect.ReflectionFactory;

public class SunClassInstantiator
implements IClassInstantiator {
    public Object newInstance(Class type) throws InstantiationException {
        try {
            Constructor customConstructor = this.getMungedConstructor(type);
            Object newValue = customConstructor.newInstance(new Object[0]);
            return newValue;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to instantiate " + type.getName() + "'s mock: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to instantiate " + type.getName() + "'s mock: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate " + type.getName() + "'s mock: " + e.getMessage());
        }
    }

    private Constructor getMungedConstructor(Class type) throws NoSuchMethodException {
        Constructor javaLangObjectConstructor = Object.class.getDeclaredConstructor(new Class[0]);
        Constructor<?> customConstructor = ReflectionFactory.getReflectionFactory().newConstructorForSerialization(type, javaLangObjectConstructor);
        return customConstructor;
    }
}

