/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Description;
import org.fest.assertions.PrimitiveAssert;
import org.fest.assertions.PrimitiveFail;

public final class ByteAssert
extends PrimitiveAssert {
    private final byte actual;
    private static final byte ZERO = 0;

    ByteAssert(byte actual) {
        this.actual = actual;
    }

    public ByteAssert as(String description) {
        this.description(description);
        return this;
    }

    public ByteAssert describedAs(String description) {
        return this.as(description);
    }

    public ByteAssert as(Description description) {
        this.description(description);
        return this;
    }

    public ByteAssert describedAs(Description description) {
        return this.as(description);
    }

    public ByteAssert isEqualTo(byte expected) {
        PrimitiveFail.failIfNotEqual(this.description(), this.actual, expected);
        return this;
    }

    public ByteAssert isNotEqualTo(byte value) {
        PrimitiveFail.failIfEqual(this.description(), this.actual, value);
        return this;
    }

    public ByteAssert isGreaterThan(byte value) {
        PrimitiveFail.failIfNotGreaterThan(this.description(), this.actual, value);
        return this;
    }

    public ByteAssert isLessThan(byte value) {
        PrimitiveFail.failIfNotLessThan(this.description(), this.actual, value);
        return this;
    }

    public ByteAssert isGreaterThanOrEqualTo(byte value) {
        PrimitiveFail.failIfNotGreaterThanOrEqualTo(this.description(), this.actual, value);
        return this;
    }

    public ByteAssert isLessThanOrEqualTo(byte value) {
        PrimitiveFail.failIfNotLessThanOrEqualTo(this.description(), this.actual, value);
        return this;
    }

    public ByteAssert isPositive() {
        return this.isGreaterThan((byte)0);
    }

    public ByteAssert isNegative() {
        return this.isLessThan((byte)0);
    }

    public ByteAssert isZero() {
        return this.isEqualTo((byte)0);
    }
}

