/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.assertions.Formatting;
import org.fest.assertions.PrimitiveAssert;
import org.fest.assertions.PrimitiveFail;
import org.fest.util.Strings;

public final class DoubleAssert
extends PrimitiveAssert {
    private static final double ZERO = 0.0;
    private final double actual;

    DoubleAssert(double actual) {
        this.actual = actual;
    }

    public DoubleAssert as(String description) {
        this.description(description);
        return this;
    }

    public DoubleAssert describedAs(String description) {
        return this.as(description);
    }

    public DoubleAssert as(Description description) {
        this.description(description);
        return this;
    }

    public DoubleAssert describedAs(Description description) {
        return this.as(description);
    }

    public DoubleAssert isEqualTo(double expected) {
        PrimitiveFail.failIfNotEqual(this.description(), this.actual, expected);
        return this;
    }

    public DoubleAssert isNotEqualTo(double value) {
        PrimitiveFail.failIfEqual(this.description(), this.actual, value);
        return this;
    }

    public DoubleAssert isGreaterThan(double value) {
        PrimitiveFail.failIfNotGreaterThan(this.description(), this.actual, value);
        return this;
    }

    public DoubleAssert isLessThan(double value) {
        PrimitiveFail.failIfNotLessThan(this.description(), this.actual, value);
        return this;
    }

    public DoubleAssert isGreaterThanOrEqualTo(double value) {
        PrimitiveFail.failIfNotGreaterThanOrEqualTo(this.description(), this.actual, value);
        return this;
    }

    public DoubleAssert isLessThanOrEqualTo(double value) {
        PrimitiveFail.failIfNotLessThanOrEqualTo(this.description(), this.actual, value);
        return this;
    }

    public DoubleAssert isPositive() {
        return this.isGreaterThan(0.0);
    }

    public DoubleAssert isNegative() {
        return this.isLessThan(0.0);
    }

    public DoubleAssert isZero() {
        return this.isEqualTo(0.0);
    }

    public DoubleAssert isNaN() {
        return this.isEqualTo(Double.NaN);
    }

    public DoubleAssert isEqualTo(double expected, Delta delta) {
        if (Double.compare(expected, this.actual) == 0) {
            return this;
        }
        if (!(Math.abs(expected - this.actual) <= delta.value)) {
            this.fail(Strings.concat((Object[])new Object[]{Fail.errorMessageIfNotEqual(this.actual, expected), " using delta:", Formatting.inBrackets(delta.value)}));
        }
        return this;
    }

    public DoubleAssert isEqualTo(double expected, org.fest.assertions.Delta delta) {
        if (Double.compare(expected, this.actual) == 0) {
            return this;
        }
        if (!(Math.abs(expected - this.actual) <= delta.value())) {
            this.fail(Strings.concat((Object[])new Object[]{Fail.errorMessageIfNotEqual(this.actual, expected), " using delta:", Formatting.inBrackets(delta.value())}));
        }
        return this;
    }

    public static Delta delta(double d) {
        return new Delta(d);
    }

    public static class Delta {
        final double value;

        private Delta(double value) {
            this.value = value;
        }
    }
}

