/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fest.assertions.Collections;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.Formatting;
import org.fest.assertions.GroupAssert;
import org.fest.assertions.Index;
import org.fest.util.Objects;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListAssert
extends GroupAssert<List<?>> {
    ListAssert(List<?> actual) {
        super(actual);
    }

    public ListAssert contains(Object o, Index index) {
        Object actualElement;
        if (index == null) {
            throw this.fail("The given index should not be null");
        }
        this.isNotNull().isNotEmpty();
        int indexValue = index.value();
        int listSize = this.actualGroupSize();
        if (indexValue < 0 || indexValue >= listSize) {
            this.failIndexOutOfBounds(indexValue);
        }
        if (!Objects.areEqual(actualElement = ((List)this.actual).get(indexValue), (Object)o)) {
            this.failElementNotFound(o, actualElement, indexValue);
        }
        return this;
    }

    private void failElementNotFound(Object e, Object a, int index) {
        this.fail(Strings.concat((Object[])new Object[]{"expecting ", Formatting.inBrackets(e), " at index ", Formatting.inBrackets(index), " but found ", Formatting.inBrackets(a)}));
    }

    private void failIndexOutOfBounds(int index) {
        this.fail(Strings.concat((Object[])new Object[]{"The index ", Formatting.inBrackets(index), " should be greater than or equal to zero and less than ", this.actualGroupSize()}));
    }

    public ListAssert containsSequence(Object ... sequence) {
        this.isNotNull();
        this.failIfNull(sequence);
        int sequenceSize = sequence.length;
        if (sequenceSize == 0) {
            return this;
        }
        int indexOfFirst = ((List)this.actual).indexOf(sequence[0]);
        if (indexOfFirst == -1) {
            this.failIfSequenceNotFound(sequence);
        }
        int listSize = this.actualGroupSize();
        for (int i = 0; i < sequenceSize; ++i) {
            int actualIndex = indexOfFirst + i;
            if (actualIndex > listSize - 1) {
                this.failIfSequenceNotFound(sequence);
            }
            if (Objects.areEqual((Object)sequence[i], ((List)this.actual).get(actualIndex))) continue;
            this.failIfSequenceNotFound(sequence);
        }
        return this;
    }

    private void failIfSequenceNotFound(Object[] notFound) {
        this.fail(Strings.concat((Object[])new Object[]{"list:", Formatting.inBrackets(this.actual), " does not contain the sequence:", Formatting.inBrackets(notFound)}));
    }

    public ListAssert startsWith(Object ... sequence) {
        this.isNotNull();
        this.failIfNull(sequence);
        int sequenceSize = sequence.length;
        int listSize = this.actualGroupSize();
        if (sequenceSize == 0 && listSize == 0) {
            return this;
        }
        if (sequenceSize == 0 && listSize != 0) {
            this.failIfNotStartingWithSequence(sequence);
        }
        if (listSize < sequenceSize) {
            this.failIfNotStartingWithSequence(sequence);
        }
        for (int i = 0; i < sequenceSize; ++i) {
            if (Objects.areEqual((Object)sequence[i], ((List)this.actual).get(i))) continue;
            this.failIfNotStartingWithSequence(sequence);
        }
        return this;
    }

    private void failIfNotStartingWithSequence(Object[] notFound) {
        this.fail(Strings.concat((Object[])new Object[]{"list:", Formatting.inBrackets(this.actual), " does not start with the sequence:", Formatting.inBrackets(notFound)}));
    }

    public ListAssert endsWith(Object ... sequence) {
        this.isNotNull();
        this.failIfNull(sequence);
        int sequenceSize = sequence.length;
        int listSize = this.actualGroupSize();
        if (sequenceSize == 0 && listSize == 0) {
            return this;
        }
        if (sequenceSize == 0 && listSize != 0) {
            this.failIfNotEndingWithSequence(sequence);
        }
        if (listSize < sequenceSize) {
            this.failIfNotEndingWithSequence(sequence);
        }
        for (int i = 0; i < sequenceSize; ++i) {
            int sequenceIndex = sequenceSize - 1 - i;
            int listIndex = listSize - 1 - i;
            if (Objects.areEqual((Object)sequence[sequenceIndex], ((List)this.actual).get(listIndex))) continue;
            this.failIfNotEndingWithSequence(sequence);
        }
        return this;
    }

    private void failIfNotEndingWithSequence(Object[] notFound) {
        this.fail(Strings.concat((Object[])new Object[]{"list:", Formatting.inBrackets(this.actual), " does not end with the sequence:", Formatting.inBrackets(notFound)}));
    }

    public ListAssert contains(Object ... objects) {
        this.isNotNull();
        this.failIfNull(objects);
        Collection<Object> notFound = Collections.notFound((Collection)this.actual, objects);
        if (!notFound.isEmpty()) {
            this.failIfElementsNotFound(notFound);
        }
        return this;
    }

    public ListAssert containsOnly(Object ... objects) {
        this.isNotNull();
        this.failIfNull(objects);
        ArrayList<Object> notFound = new ArrayList<Object>();
        ArrayList copy = new ArrayList((Collection)this.actual);
        for (Object o : objects) {
            if (!copy.contains(o)) {
                notFound.add(o);
                continue;
            }
            copy.remove(o);
        }
        if (!notFound.isEmpty()) {
            this.failIfElementsNotFound(notFound);
        }
        if (!copy.isEmpty()) {
            this.fail(Strings.concat((Object[])new Object[]{"unexpected element(s):", Formatting.inBrackets(copy), " in list:", Formatting.inBrackets(this.actual)}));
        }
        return this;
    }

    private void failIfElementsNotFound(Collection<Object> notFound) {
        this.fail(Strings.concat((Object[])new Object[]{"list:", Formatting.inBrackets(this.actual), " does not contain element(s):", Formatting.inBrackets(notFound)}));
    }

    public ListAssert excludes(Object ... objects) {
        this.isNotNull();
        this.failIfNull(objects);
        Collection<Object> found = Collections.found((Collection)this.actual, objects);
        if (!found.isEmpty()) {
            this.fail(Strings.concat((Object[])new Object[]{"list:", Formatting.inBrackets(this.actual), " does not exclude element(s):", Formatting.inBrackets(found)}));
        }
        return this;
    }

    private void failIfNull(Object[] objects) {
        if (objects == null) {
            this.fail("the given array of objects should not be null");
        }
    }

    public ListAssert doesNotHaveDuplicates() {
        this.isNotNull();
        Collection duplicates = org.fest.util.Collections.duplicatesFrom((Collection)((Collection)this.actual));
        if (!duplicates.isEmpty()) {
            this.fail(Strings.concat((Object[])new Object[]{"list:", Formatting.inBrackets(this.actual), " contains duplicate(s):", Formatting.inBrackets(duplicates)}));
        }
        return this;
    }

    public ListAssert as(String description) {
        this.description(description);
        return this;
    }

    public ListAssert describedAs(String description) {
        return this.as(description);
    }

    public ListAssert as(Description description) {
        this.description(description);
        return this;
    }

    public ListAssert describedAs(Description description) {
        return this.as(description);
    }

    public ListAssert satisfies(Condition<List<?>> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public ListAssert doesNotSatisfy(Condition<List<?>> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public ListAssert hasSize(int expected) {
        int actualSize = this.actualGroupSize();
        if (actualSize != expected) {
            this.fail(Strings.concat((Object[])new Object[]{"expected size:", Formatting.inBrackets(expected), " but was:", Formatting.inBrackets(actualSize), " for list:", Formatting.inBrackets(this.actual)}));
        }
        return this;
    }

    @Override
    protected int actualGroupSize() {
        this.isNotNull();
        return ((List)this.actual).size();
    }

    @Override
    public void isEmpty() {
        this.isNotNull();
        if (!org.fest.util.Collections.isEmpty((Collection)((Collection)this.actual))) {
            this.fail(Strings.concat((Object[])new Object[]{"expecting empty list, but was:", Formatting.inBrackets(this.actual)}));
        }
    }

    public ListAssert isNotEmpty() {
        this.isNotNull();
        if (((List)this.actual).isEmpty()) {
            this.fail("expecting a non-empty list, but it was empty");
        }
        return this;
    }

    @Override
    public void isNullOrEmpty() {
        if (org.fest.util.Collections.isEmpty((Collection)((Collection)this.actual))) {
            return;
        }
        this.fail(Strings.concat((Object[])new Object[]{"expecting a null or empty list, but was:", Formatting.inBrackets(this.actual)}));
    }

    public ListAssert isNotNull() {
        if (this.actual == null) {
            this.fail("expecting a non-null list, but it was null");
        }
        return this;
    }

    public ListAssert containsExactly(Object ... objects) {
        this.failIfNull(objects);
        return this.isNotNull().isEqualTo(org.fest.util.Collections.list((Object[])objects));
    }

    public ListAssert isEqualTo(List<?> expected) {
        this.assertEqualTo(expected);
        return this;
    }

    public ListAssert isNotEqualTo(List<?> other) {
        this.assertNotEqualTo(other);
        return this;
    }

    public ListAssert isSameAs(List<?> expected) {
        this.assertSameAs(expected);
        return this;
    }

    public ListAssert isNotSameAs(List<?> other) {
        this.assertNotSameAs(other);
        return this;
    }
}

