/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Collection;
import org.fest.assertions.Collections;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.Formatting;
import org.fest.assertions.GroupAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionAssert
extends GroupAssert<Collection<?>> {
    CollectionAssert(Collection<?> actual) {
        super(actual);
    }

    public CollectionAssert contains(Object ... objects) {
        this.isNotNull();
        this.failIfNull(objects);
        Collection<Object> notFound = Collections.notFound((Collection)this.actual, objects);
        if (!notFound.isEmpty()) {
            this.failIfElementsNotFound(notFound);
        }
        return this;
    }

    public CollectionAssert containsOnly(Object ... objects) {
        this.isNotNull();
        this.failIfNull(objects);
        ArrayList<Object> notFound = new ArrayList<Object>();
        ArrayList copy = new ArrayList((Collection)this.actual);
        for (Object o : objects) {
            if (!copy.contains(o)) {
                notFound.add(o);
                continue;
            }
            copy.remove(o);
        }
        if (!notFound.isEmpty()) {
            this.failIfElementsNotFound(notFound);
        }
        if (!copy.isEmpty()) {
            this.fail(Strings.concat((Object[])new Object[]{"unexpected element(s):", this.format(copy), " in collection:", this.format((Collection)this.actual)}));
        }
        return this;
    }

    private void failIfElementsNotFound(Collection<Object> notFound) {
        this.fail(Strings.concat((Object[])new Object[]{"collection:", this.format((Collection)this.actual), " does not contain element(s):", this.format(notFound)}));
    }

    public CollectionAssert excludes(Object ... objects) {
        this.isNotNull();
        this.failIfNull(objects);
        Collection<Object> found = Collections.found((Collection)this.actual, objects);
        if (!found.isEmpty()) {
            this.fail(Strings.concat((Object[])new Object[]{"collection:", this.format((Collection)this.actual), " does not exclude element(s):", this.format(found)}));
        }
        return this;
    }

    private void failIfNull(Object[] objects) {
        if (objects == null) {
            this.fail("the given array of objects should not be null");
        }
    }

    public CollectionAssert doesNotHaveDuplicates() {
        this.isNotNull();
        Collection duplicates = org.fest.util.Collections.duplicatesFrom((Collection)((Collection)this.actual));
        if (!duplicates.isEmpty()) {
            this.fail(Strings.concat((Object[])new Object[]{"collection:", this.format((Collection)this.actual), " contains duplicate(s):", this.format(duplicates)}));
        }
        return this;
    }

    private String format(Collection<?> c) {
        return Formatting.inBrackets(c);
    }

    public CollectionAssert as(String description) {
        this.description(description);
        return this;
    }

    public CollectionAssert describedAs(String description) {
        return this.as(description);
    }

    public CollectionAssert as(Description description) {
        this.description(description);
        return this;
    }

    public CollectionAssert describedAs(Description description) {
        return this.as(description);
    }

    public CollectionAssert satisfies(Condition<Collection<?>> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public CollectionAssert doesNotSatisfy(Condition<Collection<?>> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    @Override
    public void isNullOrEmpty() {
        if (org.fest.util.Collections.isEmpty((Collection)((Collection)this.actual))) {
            return;
        }
        this.fail(Strings.concat((Object[])new Object[]{"expecting a null or empty collection, but was:", this.format((Collection)this.actual)}));
    }

    public CollectionAssert isNotNull() {
        if (this.actual == null) {
            this.fail("expecting a non-null collection, but it was null");
        }
        return this;
    }

    @Override
    public void isEmpty() {
        this.isNotNull();
        if (!org.fest.util.Collections.isEmpty((Collection)((Collection)this.actual))) {
            this.fail(Strings.concat((Object[])new Object[]{"expecting empty collection, but was:", this.format((Collection)this.actual)}));
        }
    }

    public CollectionAssert isNotEmpty() {
        this.isNotNull();
        if (((Collection)this.actual).isEmpty()) {
            this.fail("expecting a non-empty collection, but it was empty");
        }
        return this;
    }

    public CollectionAssert hasSize(int expected) {
        int actualSize = this.actualGroupSize();
        if (actualSize != expected) {
            this.fail(Strings.concat((Object[])new Object[]{"expected size:", Formatting.inBrackets(expected), " but was:", Formatting.inBrackets(actualSize), " for collection:", this.format((Collection)this.actual)}));
        }
        return this;
    }

    @Override
    protected int actualGroupSize() {
        this.isNotNull();
        return ((Collection)this.actual).size();
    }

    public CollectionAssert isEqualTo(Collection<?> expected) {
        this.assertEqualTo(expected);
        return this;
    }

    public CollectionAssert isNotEqualTo(Collection<?> other) {
        this.assertNotEqualTo(other);
        return this;
    }

    public CollectionAssert isSameAs(Collection<?> expected) {
        this.assertSameAs(expected);
        return this;
    }

    public CollectionAssert isNotSameAs(Collection<?> other) {
        this.assertNotSameAs(other);
        return this;
    }
}

