/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.ComparisonFailureFactory;
import org.fest.assertions.Formatting;
import org.fest.util.Objects;
import org.fest.util.Strings;

public final class Fail {
    public static void fail() {
        Fail.fail(null);
    }

    public static void fail(String message, Throwable realCause) {
        AssertionError error = new AssertionError((Object)message);
        ((Throwable)((Object)error)).initCause(realCause);
        throw error;
    }

    static void failIfEqual(String message, Object first, Object second) {
        if (Objects.areEqual((Object)first, (Object)second)) {
            Fail.fail(Fail.errorMessageIfEqual(message, first, second));
        }
    }

    static void failIfNotEqual(String message, Object actual, Object expected) {
        if (Objects.areEqual((Object)actual, (Object)expected)) {
            return;
        }
        AssertionError comparisonFailure = ComparisonFailureFactory.comparisonFailure(message, expected, actual);
        if (comparisonFailure != null) {
            throw comparisonFailure;
        }
        Fail.fail(Fail.errorMessageIfNotEqual(message, actual, expected));
    }

    static void failIfNull(String message, Object o) {
        if (o == null) {
            Fail.fail(Strings.concat((Object[])new Object[]{Formatting.format(message), "expecting a non-null object, but it was null"}));
        }
    }

    static void failIfNotNull(String message, Object o) {
        if (o != null) {
            Fail.fail(Strings.concat((Object[])new Object[]{Formatting.format(message), Formatting.inBrackets(o), " should be null"}));
        }
    }

    static void failIfSame(String message, Object first, Object second) {
        if (first == second) {
            Fail.fail(Strings.concat((Object[])new Object[]{Formatting.format(message), "given objects are same:", Formatting.inBrackets(first)}));
        }
    }

    static void failIfNotSame(String message, Object first, Object second) {
        if (first != second) {
            Fail.fail(Strings.concat((Object[])new Object[]{Formatting.format(message), "expected same instance but found:", Formatting.inBrackets(first), " and:", Formatting.inBrackets(second)}));
        }
    }

    public static AssertionError fail(String message) {
        throw new AssertionError((Object)message);
    }

    static String errorMessageIfNotEqual(String message, Object actual, Object expected) {
        return Strings.concat((Object[])new Object[]{Formatting.format(message), Fail.errorMessageIfNotEqual(actual, expected)});
    }

    static String errorMessageIfNotEqual(Object actual, Object expected) {
        return Strings.concat((Object[])new Object[]{"expected:", Formatting.inBrackets(expected), " but was:", Formatting.inBrackets(actual)});
    }

    static String errorMessageIfEqual(String message, Object actual, Object o) {
        return Strings.concat((Object[])new Object[]{Formatting.format(message), Fail.errorMessageIfEqual(actual, o)});
    }

    static String errorMessageIfEqual(Object actual, Object o) {
        return Fail.comparisonFailed(actual, " should not be equal to:", o);
    }

    static String errorMessageIfNotGreaterThan(String message, Object actual, Object value) {
        return Strings.concat((Object[])new Object[]{Formatting.format(message), Fail.errorMessageIfNotGreaterThan(actual, value)});
    }

    static String errorMessageIfNotGreaterThan(Object actual, Object value) {
        return Fail.comparisonFailed(actual, " should be greater than:", value);
    }

    static String errorMessageIfNotGreaterThanOrEqualTo(String message, Object actual, Object value) {
        return Strings.concat((Object[])new Object[]{Formatting.format(message), Fail.errorMessageIfNotGreaterThanOrEqualTo(actual, value)});
    }

    static String errorMessageIfNotGreaterThanOrEqualTo(Object actual, Object value) {
        return Fail.comparisonFailed(actual, " should be greater than or equal to:", value);
    }

    static String errorMessageIfNotLessThan(String message, Object actual, Object value) {
        return Strings.concat((Object[])new Object[]{Formatting.format(message), Fail.errorMessageIfNotLessThan(actual, value)});
    }

    static String errorMessageIfNotLessThan(Object actual, Object value) {
        return Fail.comparisonFailed(actual, " should be less than:", value);
    }

    static String errorMessageIfNotLessThanOrEqualTo(String message, Object actual, Object value) {
        return Strings.concat((Object[])new Object[]{Formatting.format(message), Fail.errorMessageIfNotLessThanOrEqualTo(actual, value)});
    }

    static String errorMessageIfNotLessThanOrEqualTo(Object actual, Object value) {
        return Fail.comparisonFailed(actual, " should be less than or equal to:", value);
    }

    private static String comparisonFailed(Object actual, String reason, Object expected) {
        return Fail.comparisonFailed(null, actual, reason, expected);
    }

    private static String comparisonFailed(String message, Object actual, String reason, Object expected) {
        return Strings.concat((Object[])new Object[]{Formatting.format(message), "actual value:", Formatting.inBrackets(actual), reason, Formatting.inBrackets(expected)});
    }

    private Fail() {
    }
}

