/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.assertions.Formatting;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.ImageReader;
import org.fest.assertions.RGBColor;
import org.fest.assertions.Threshold;
import org.fest.util.Objects;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageAssert
extends GenericAssert<BufferedImage> {
    private static final Threshold ZERO_THRESHOLD = Threshold.threshold(0);
    private static ImageReader imageReader = new ImageReader();

    public static BufferedImage read(String imageFilePath) throws IOException {
        File imageFile = new File(imageFilePath);
        if (!imageFile.isFile()) {
            throw new IllegalArgumentException(Strings.concat((Object[])new Object[]{"The path ", Strings.quote((String)imageFilePath), " does not belong to a file"}));
        }
        try {
            return imageReader.read(imageFile);
        }
        catch (IOException e) {
            throw new IOException(Strings.concat((Object[])new Object[]{"Unable to read image from file ", Strings.quote((String)imageFilePath)}), e);
        }
    }

    ImageAssert(BufferedImage actual) {
        super(actual);
    }

    public ImageAssert as(String description) {
        this.description(description);
        return this;
    }

    public ImageAssert describedAs(String description) {
        return this.as(description);
    }

    public ImageAssert as(Description description) {
        this.description(description);
        return this;
    }

    public ImageAssert describedAs(Description description) {
        return this.as(description);
    }

    public ImageAssert satisfies(Condition<BufferedImage> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public ImageAssert doesNotSatisfy(Condition<BufferedImage> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public ImageAssert isEqualTo(BufferedImage expected) {
        return this.isEqualTo(expected, ZERO_THRESHOLD);
    }

    public ImageAssert isEqualTo(BufferedImage expected, Threshold threshold) {
        if (Objects.areEqual((Object)this.actual, (Object)expected)) {
            return this;
        }
        this.failIfNull(expected);
        this.failIfNotEqual(ImageAssert.sizeOf((BufferedImage)this.actual), ImageAssert.sizeOf(expected));
        this.failIfNotEqualColor(expected, threshold);
        return this;
    }

    private void failIfNull(BufferedImage expected) {
        if (expected != null) {
            return;
        }
        this.fail(Fail.errorMessageIfNotEqual(this.actual, null));
    }

    private void failIfNotEqual(Dimension a, Dimension e) {
        if (!Objects.areEqual((Object)a, (Object)e)) {
            this.fail(Strings.concat((Object[])new Object[]{"image size, expected:", Formatting.inBrackets(e), " but was:", Formatting.inBrackets(a)}));
        }
    }

    private void failIfNotEqualColor(BufferedImage expected, Threshold threshold) {
        int w = ((BufferedImage)this.actual).getWidth();
        int h = ((BufferedImage)this.actual).getHeight();
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                this.failIfNotEqual(new RGBColor(((BufferedImage)this.actual).getRGB(x, y)), new RGBColor(expected.getRGB(x, y)), threshold, x, y);
            }
        }
    }

    private void failIfNotEqual(RGBColor a, RGBColor e, Threshold threshold, int x, int y) {
        if (a.isEqualTo(e, threshold.value())) {
            return;
        }
        this.fail(Strings.concat((Object[])new Object[]{"expected:", Formatting.inBrackets(a), " but was:", Formatting.inBrackets(e), " at pixel [", String.valueOf(x), ",", String.valueOf(y), "]"}));
    }

    public ImageAssert isNotEqualTo(BufferedImage image) {
        if (Objects.areEqual((Object)this.actual, (Object)image)) {
            this.fail(Fail.errorMessageIfEqual(this.actual, image));
        }
        if (image == null) {
            return this;
        }
        if (Objects.areEqual((Object)ImageAssert.sizeOf((BufferedImage)this.actual), (Object)ImageAssert.sizeOf(image)) && this.hasEqualColor(image)) {
            this.fail("images are equal");
        }
        return this;
    }

    private static Dimension sizeOf(BufferedImage image) {
        return new Dimension(image.getWidth(), image.getHeight());
    }

    private boolean hasEqualColor(BufferedImage expected) {
        int w = ((BufferedImage)this.actual).getWidth();
        int h = ((BufferedImage)this.actual).getHeight();
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                if (((BufferedImage)this.actual).getRGB(x, y) == expected.getRGB(x, y)) continue;
                return false;
            }
        }
        return true;
    }

    public ImageAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public ImageAssert isNotSameAs(BufferedImage expected) {
        this.assertNotSameAs(expected);
        return this;
    }

    public ImageAssert isSameAs(BufferedImage expected) {
        this.assertSameAs(expected);
        return this;
    }

    public ImageAssert hasSize(Dimension expected) {
        this.isNotNull();
        if (expected == null) {
            throw new IllegalArgumentException("The size to compare to should not be null");
        }
        Dimension actualDimension = new Dimension(((BufferedImage)this.actual).getWidth(), ((BufferedImage)this.actual).getHeight());
        Fail.failIfNotEqual(this.description(), actualDimension, expected);
        return this;
    }

    static void imageReader(ImageReader newImageReader) {
        imageReader = newImageReader;
    }
}

