/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayAssert
extends ArrayAssert<byte[]> {
    protected ByteArrayAssert(byte ... actual) {
        super(actual);
    }

    @Override
    public ByteArrayAssert as(String description) {
        this.description(description);
        return this;
    }

    @Override
    public ByteArrayAssert describedAs(String description) {
        return this.as(description);
    }

    @Override
    public ByteArrayAssert as(Description description) {
        this.description(description);
        return this;
    }

    @Override
    public ByteArrayAssert describedAs(Description description) {
        return this.as(description);
    }

    public ByteArrayAssert contains(byte ... values) {
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    public ByteArrayAssert containsOnly(byte ... values) {
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    public ByteArrayAssert excludes(byte ... values) {
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    public ByteArrayAssert satisfies(Condition<byte[]> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public ByteArrayAssert doesNotSatisfy(Condition<byte[]> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public ByteArrayAssert is(Condition<byte[]> condition) {
        this.assertIs(condition);
        return this;
    }

    public ByteArrayAssert isNot(Condition<byte[]> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public ByteArrayAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public ByteArrayAssert isNotEmpty() {
        this.assertIsNotEmpty();
        return this;
    }

    public ByteArrayAssert isEqualTo(byte[] expected) {
        if (Arrays.equals((byte[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    public ByteArrayAssert isNotEqualTo(byte[] array) {
        if (!Arrays.equals((byte[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }

    public ByteArrayAssert hasSize(int expected) {
        this.assertHasSize(expected);
        return this;
    }

    public ByteArrayAssert isSameAs(byte[] expected) {
        this.assertSameAs(expected);
        return this;
    }

    public ByteArrayAssert isNotSameAs(byte[] expected) {
        this.assertNotSameAs(expected);
        return this;
    }

    @Override
    public ByteArrayAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }
}

