/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.NumberAssert;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteAssert
extends GenericAssert<Byte>
implements NumberAssert {
    private static final byte ZERO = 0;

    @VisibleForTesting
    ByteAssert(int actual) {
        this((byte)actual);
    }

    protected ByteAssert(byte actual) {
        super(actual);
    }

    protected ByteAssert(Byte actual) {
        super(actual);
    }

    public ByteAssert as(String description) {
        this.description(description);
        return this;
    }

    public ByteAssert describedAs(String description) {
        return this.as(description);
    }

    public ByteAssert as(Description description) {
        this.description(description);
        return this;
    }

    public ByteAssert describedAs(Description description) {
        return this.as(description);
    }

    public ByteAssert isEqualTo(byte expected) {
        return this.isEqualTo((Byte)expected);
    }

    public ByteAssert isEqualTo(Byte expected) {
        this.assertEqualTo(expected);
        return this;
    }

    public ByteAssert isNotEqualTo(byte other) {
        return this.isNotEqualTo((Byte)other);
    }

    public ByteAssert isNotEqualTo(Byte other) {
        this.assertNotEqualTo(other);
        return this;
    }

    public ByteAssert isGreaterThan(byte other) {
        if ((Byte)this.actual > other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, other));
    }

    public ByteAssert isLessThan(byte other) {
        if ((Byte)this.actual < other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, other));
    }

    public ByteAssert isGreaterThanOrEqualTo(byte other) {
        if ((Byte)this.actual >= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, other));
    }

    public ByteAssert isLessThanOrEqualTo(byte other) {
        if ((Byte)this.actual <= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, other));
    }

    @Override
    public ByteAssert isZero() {
        return this.isEqualTo((byte)0);
    }

    @Override
    public ByteAssert isPositive() {
        return this.isGreaterThan((byte)0);
    }

    @Override
    public ByteAssert isNegative() {
        return this.isLessThan((byte)0);
    }

    public ByteAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }

    public ByteAssert satisfies(Condition<Byte> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public ByteAssert doesNotSatisfy(Condition<Byte> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public ByteAssert is(Condition<Byte> condition) {
        this.assertIs(condition);
        return this;
    }

    public ByteAssert isNot(Condition<Byte> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public ByteAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public ByteAssert isSameAs(Byte expected) {
        this.assertSameAs(expected);
        return this;
    }

    public ByteAssert isNotSameAs(Byte other) {
        this.assertNotSameAs(other);
        return this;
    }
}

