/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharArrayAssert
extends ArrayAssert<char[]> {
    protected CharArrayAssert(char ... actual) {
        super(actual);
    }

    @Override
    public CharArrayAssert as(String description) {
        this.description(description);
        return this;
    }

    @Override
    public CharArrayAssert describedAs(String description) {
        return this.as(description);
    }

    @Override
    public CharArrayAssert as(Description description) {
        this.description(description);
        return this;
    }

    @Override
    public CharArrayAssert describedAs(Description description) {
        return this.as(description);
    }

    public CharArrayAssert contains(char ... values) {
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    public CharArrayAssert containsOnly(char ... values) {
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    public CharArrayAssert excludes(char ... values) {
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    public CharArrayAssert satisfies(Condition<char[]> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public CharArrayAssert doesNotSatisfy(Condition<char[]> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public CharArrayAssert is(Condition<char[]> condition) {
        this.assertIs(condition);
        return this;
    }

    public CharArrayAssert isNot(Condition<char[]> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public CharArrayAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public CharArrayAssert isNotEmpty() {
        this.assertIsNotEmpty();
        return this;
    }

    public CharArrayAssert isEqualTo(char[] expected) {
        if (Arrays.equals((char[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    public CharArrayAssert isNotEqualTo(char[] array) {
        if (!Arrays.equals((char[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }

    public CharArrayAssert hasSize(int expected) {
        this.assertHasSize(expected);
        return this;
    }

    public CharArrayAssert isSameAs(char[] expected) {
        this.assertSameAs(expected);
        return this;
    }

    public CharArrayAssert isNotSameAs(char[] expected) {
        this.assertNotSameAs(expected);
        return this;
    }

    @Override
    public CharArrayAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }
}

