/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Formatting;
import org.fest.assertions.GenericAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharAssert
extends GenericAssert<Character> {
    protected CharAssert(char actual) {
        super(Character.valueOf(actual));
    }

    protected CharAssert(Character actual) {
        super(actual);
    }

    public CharAssert as(String description) {
        this.description(description);
        return this;
    }

    public CharAssert describedAs(String description) {
        return this.as(description);
    }

    public CharAssert as(Description description) {
        this.description(description);
        return this;
    }

    public CharAssert describedAs(Description description) {
        return this.as(description);
    }

    public CharAssert isEqualTo(char expected) {
        return this.isEqualTo(Character.valueOf(expected));
    }

    public CharAssert isEqualTo(Character expected) {
        this.assertEqualTo(expected);
        return this;
    }

    public CharAssert isNotEqualTo(char other) {
        return this.isNotEqualTo(Character.valueOf(other));
    }

    public CharAssert isNotEqualTo(Character other) {
        this.assertNotEqualTo(other);
        return this;
    }

    public CharAssert isGreaterThan(char other) {
        if (((Character)this.actual).charValue() > other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, Character.valueOf(other)));
    }

    public CharAssert isLessThan(char other) {
        if (((Character)this.actual).charValue() < other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, Character.valueOf(other)));
    }

    public CharAssert isGreaterThanOrEqualTo(char other) {
        if (((Character)this.actual).charValue() >= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, Character.valueOf(other)));
    }

    public CharAssert isLessThanOrEqualTo(char other) {
        if (((Character)this.actual).charValue() <= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, Character.valueOf(other)));
    }

    public CharAssert isUpperCase() {
        if (Character.isUpperCase(((Character)this.actual).charValue())) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{Formatting.inBrackets(this.actual), " should be an upper-case character"}));
    }

    public CharAssert isLowerCase() {
        if (Character.isLowerCase(((Character)this.actual).charValue())) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{Formatting.inBrackets(this.actual), " should be a lower-case character"}));
    }

    public CharAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }

    public CharAssert satisfies(Condition<Character> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public CharAssert doesNotSatisfy(Condition<Character> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public CharAssert is(Condition<Character> condition) {
        this.assertIs(condition);
        return this;
    }

    public CharAssert isNot(Condition<Character> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public CharAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public CharAssert isSameAs(Character expected) {
        this.assertSameAs(expected);
        return this;
    }

    public CharAssert isNotSameAs(Character other) {
        this.assertNotSameAs(other);
        return this;
    }
}

