/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.ObjectGroupAssert;
import org.fest.assertions.PropertySupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionAssert
extends ObjectGroupAssert<Collection<?>> {
    protected CollectionAssert(Collection<?> actual) {
        super(actual);
    }

    public CollectionAssert contains(Object ... objects) {
        this.assertContains(objects);
        return this;
    }

    public CollectionAssert containsOnly(Object ... objects) {
        this.assertContainsOnly(objects);
        return this;
    }

    public CollectionAssert excludes(Object ... objects) {
        this.assertExcludes(objects);
        return this;
    }

    public CollectionAssert doesNotHaveDuplicates() {
        this.assertDoesNotHaveDuplicates();
        return this;
    }

    @Override
    public CollectionAssert as(String description) {
        this.description(description);
        return this;
    }

    @Override
    public CollectionAssert describedAs(String description) {
        return this.as(description);
    }

    @Override
    public CollectionAssert as(Description description) {
        this.description(description);
        return this;
    }

    @Override
    public CollectionAssert describedAs(Description description) {
        return this.as(description);
    }

    public CollectionAssert satisfies(Condition<Collection<?>> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public CollectionAssert doesNotSatisfy(Condition<Collection<?>> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public CollectionAssert is(Condition<Collection<?>> condition) {
        this.assertIs(condition);
        return this;
    }

    public CollectionAssert isNot(Condition<Collection<?>> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public CollectionAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public CollectionAssert isNotEmpty() {
        this.assertIsNotEmpty();
        return this;
    }

    public CollectionAssert hasSize(int expected) {
        this.assertHasSize(expected);
        return this;
    }

    @Override
    protected int actualGroupSize() {
        this.isNotNull();
        return ((Collection)this.actual).size();
    }

    public CollectionAssert isEqualTo(Collection<?> expected) {
        this.assertEqualTo(expected);
        return this;
    }

    public CollectionAssert isNotEqualTo(Collection<?> other) {
        this.assertNotEqualTo(other);
        return this;
    }

    public CollectionAssert isSameAs(Collection<?> expected) {
        this.assertSameAs(expected);
        return this;
    }

    public CollectionAssert isNotSameAs(Collection<?> other) {
        this.assertNotSameAs(other);
        return this;
    }

    @Override
    public CollectionAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }

    public CollectionAssert onProperty(String propertyName) {
        this.isNotNull();
        if (((Collection)this.actual).isEmpty()) {
            return new CollectionAssert(Collections.emptyList());
        }
        return new CollectionAssert((Collection<?>)PropertySupport.propertyValues(propertyName, (Collection)this.actual));
    }

    @Override
    protected Set<Object> actualAsSet() {
        return new HashSet<Object>((Collection)this.actual);
    }

    @Override
    protected List<Object> actualAsList() {
        return new ArrayList<Object>((Collection)this.actual);
    }
}

