/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatArrayAssert
extends ArrayAssert<float[]> {
    protected FloatArrayAssert(float ... actual) {
        super(actual);
    }

    @Override
    public FloatArrayAssert as(String description) {
        this.description(description);
        return this;
    }

    @Override
    public FloatArrayAssert describedAs(String description) {
        return this.as(description);
    }

    @Override
    public FloatArrayAssert as(Description description) {
        this.description(description);
        return this;
    }

    @Override
    public FloatArrayAssert describedAs(Description description) {
        return this.as(description);
    }

    public FloatArrayAssert contains(float ... values) {
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    public FloatArrayAssert containsOnly(float ... values) {
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    public FloatArrayAssert excludes(float ... values) {
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    public FloatArrayAssert satisfies(Condition<float[]> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public FloatArrayAssert doesNotSatisfy(Condition<float[]> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public FloatArrayAssert is(Condition<float[]> condition) {
        this.assertIs(condition);
        return this;
    }

    public FloatArrayAssert isNot(Condition<float[]> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public FloatArrayAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public FloatArrayAssert isNotEmpty() {
        this.assertIsNotEmpty();
        return this;
    }

    public FloatArrayAssert isEqualTo(float[] expected) {
        if (Arrays.equals((float[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    public FloatArrayAssert isNotEqualTo(float[] array) {
        if (!Arrays.equals((float[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }

    public FloatArrayAssert hasSize(int expected) {
        this.assertHasSize(expected);
        return this;
    }

    public FloatArrayAssert isSameAs(float[] expected) {
        this.assertSameAs(expected);
        return this;
    }

    public FloatArrayAssert isNotSameAs(float[] expected) {
        this.assertNotSameAs(expected);
        return this;
    }

    @Override
    public FloatArrayAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }
}

