/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntArrayAssert
extends ArrayAssert<int[]> {
    protected IntArrayAssert(int ... actual) {
        super(actual);
    }

    @Override
    public IntArrayAssert as(String description) {
        this.description(description);
        return this;
    }

    @Override
    public IntArrayAssert describedAs(String description) {
        return this.as(description);
    }

    @Override
    public IntArrayAssert as(Description description) {
        this.description(description);
        return this;
    }

    @Override
    public IntArrayAssert describedAs(Description description) {
        return this.as(description);
    }

    public IntArrayAssert contains(int ... values) {
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    public IntArrayAssert containsOnly(int ... values) {
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    public IntArrayAssert excludes(int ... values) {
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    public IntArrayAssert satisfies(Condition<int[]> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public IntArrayAssert doesNotSatisfy(Condition<int[]> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public IntArrayAssert is(Condition<int[]> condition) {
        this.assertIs(condition);
        return this;
    }

    public IntArrayAssert isNot(Condition<int[]> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public IntArrayAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public IntArrayAssert isNotEmpty() {
        this.assertIsNotEmpty();
        return this;
    }

    public IntArrayAssert isEqualTo(int[] expected) {
        if (Arrays.equals((int[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    public IntArrayAssert isNotEqualTo(int[] array) {
        if (!Arrays.equals((int[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }

    public IntArrayAssert hasSize(int expected) {
        this.assertHasSize(expected);
        return this;
    }

    public IntArrayAssert isSameAs(int[] expected) {
        this.assertSameAs(expected);
        return this;
    }

    public IntArrayAssert isNotSameAs(int[] expected) {
        this.assertNotSameAs(expected);
        return this;
    }

    @Override
    public IntArrayAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }
}

