/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.fest.assertions.Collections;
import org.fest.assertions.Formatting;
import org.fest.assertions.GroupAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ItemGroupAssert<T>
extends GroupAssert<T> {
    public ItemGroupAssert(T actual) {
        super(actual);
    }

    protected final void assertContains(Object ... objects) {
        this.isNotNull();
        this.validateIsNotNull(objects);
        Collection<Object> notFound = this.notFoundInActual(objects);
        if (notFound.isEmpty()) {
            return;
        }
        throw this.failureIfExpectedElementsNotFound(notFound);
    }

    private Collection<Object> notFoundInActual(Object ... objects) {
        return Collections.notFound(this.actualAsSet(), objects);
    }

    protected final void assertContainsOnly(Object ... objects) {
        this.isNotNull();
        this.validateIsNotNull(objects);
        Set<Object> copy = this.actualAsSet();
        List<Object> notFound = this.notFoundInCopy(copy, ItemGroupAssert.asSet(objects));
        if (!notFound.isEmpty()) {
            throw this.failureIfExpectedElementsNotFound(notFound);
        }
        if (copy.isEmpty()) {
            return;
        }
        throw this.failureIfUnexpectedElementsFound(copy);
    }

    protected abstract Set<Object> actualAsSet();

    protected static Set<Object> asSet(Object[] objects) {
        LinkedHashSet<Object> s = new LinkedHashSet<Object>();
        for (Object o : objects) {
            s.add(o);
        }
        return s;
    }

    private List<Object> notFoundInCopy(Set<Object> copy, Set<Object> objects) {
        ArrayList<Object> notFound = new ArrayList<Object>();
        for (Object o : objects) {
            if (!copy.contains(o)) {
                notFound.add(o);
                continue;
            }
            copy.remove(o);
        }
        return notFound;
    }

    private AssertionError failureIfExpectedElementsNotFound(Collection<Object> notFound) {
        this.failIfCustomMessageIsSet();
        return this.failure(Strings.concat((Object[])new Object[]{Formatting.inBrackets(this.actual), " does not contain element(s):", Formatting.inBrackets(notFound)}));
    }

    private AssertionError failureIfUnexpectedElementsFound(Collection<Object> unexpected) {
        this.failIfCustomMessageIsSet();
        return this.failure(Strings.concat((Object[])new Object[]{"unexpected element(s):", Formatting.inBrackets(unexpected), " in ", Formatting.inBrackets(this.actual)}));
    }

    protected final void assertExcludes(Object ... objects) {
        this.isNotNull();
        this.validateIsNotNull(objects);
        Collection<Object> found = Collections.found(this.actualAsSet(), objects);
        if (found.isEmpty()) {
            return;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{Formatting.inBrackets(this.actual), " does not exclude element(s):", Formatting.inBrackets(found)}));
    }

    protected final void validateIsNotNull(Object[] objects) {
        if (objects == null) {
            throw new NullPointerException(this.formattedErrorMessage("The given array should not be null"));
        }
    }

    protected final void assertDoesNotHaveDuplicates() {
        this.isNotNull();
        Collection duplicates = org.fest.util.Collections.duplicatesFrom(this.actualAsList());
        if (duplicates.isEmpty()) {
            return;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{Formatting.inBrackets(this.actual), " contains duplicate(s):", Formatting.inBrackets(duplicates)}));
    }

    protected abstract List<Object> actualAsList();
}

