/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.NumberAssert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongAssert
extends GenericAssert<Long>
implements NumberAssert {
    private static final long ZERO = 0L;

    protected LongAssert(long actual) {
        super(actual);
    }

    protected LongAssert(Long actual) {
        super(actual);
    }

    public LongAssert as(String description) {
        this.description(description);
        return this;
    }

    public LongAssert describedAs(String description) {
        return this.as(description);
    }

    public LongAssert as(Description description) {
        this.description(description);
        return this;
    }

    public LongAssert describedAs(Description description) {
        return this.as(description);
    }

    public LongAssert isEqualTo(long expected) {
        return this.isEqualTo((Long)expected);
    }

    public LongAssert isEqualTo(Long expected) {
        this.assertEqualTo(expected);
        return this;
    }

    public LongAssert isNotEqualTo(long other) {
        return this.isNotEqualTo((Long)other);
    }

    public LongAssert isNotEqualTo(Long other) {
        this.assertNotEqualTo(other);
        return this;
    }

    public LongAssert isGreaterThan(long other) {
        if ((Long)this.actual > other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, other));
    }

    public LongAssert isLessThan(long other) {
        if ((Long)this.actual < other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, other));
    }

    public LongAssert isGreaterThanOrEqualTo(long other) {
        if ((Long)this.actual >= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, other));
    }

    public LongAssert isLessThanOrEqualTo(long other) {
        if ((Long)this.actual <= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, other));
    }

    @Override
    public LongAssert isZero() {
        return this.isEqualTo(0L);
    }

    @Override
    public LongAssert isPositive() {
        return this.isGreaterThan(0L);
    }

    @Override
    public LongAssert isNegative() {
        return this.isLessThan(0L);
    }

    public LongAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }

    public LongAssert satisfies(Condition<Long> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public LongAssert doesNotSatisfy(Condition<Long> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public LongAssert is(Condition<Long> condition) {
        this.assertIs(condition);
        return this;
    }

    public LongAssert isNot(Condition<Long> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public LongAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public LongAssert isSameAs(Long expected) {
        this.assertSameAs(expected);
        return this;
    }

    public LongAssert isNotSameAs(Long other) {
        this.assertNotSameAs(other);
        return this;
    }
}

