/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.Formatting;
import org.fest.assertions.GroupAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapAssert
extends GroupAssert<Map<?, ?>> {
    private static final String ENTRY = "entry";
    private static final String ENTRIES = "entries";

    protected MapAssert(Map<?, ?> actual) {
        super(actual);
    }

    @Override
    public MapAssert as(String description) {
        this.description(description);
        return this;
    }

    @Override
    public MapAssert describedAs(String description) {
        return this.as(description);
    }

    @Override
    public MapAssert as(Description description) {
        this.description(description);
        return this;
    }

    @Override
    public MapAssert describedAs(Description description) {
        return this.as(description);
    }

    public MapAssert includes(Entry ... entries) {
        this.isNotNull();
        this.validate(ENTRIES, entries);
        ArrayList<Entry> notFound = new ArrayList<Entry>();
        for (Entry e : entries) {
            if (this.containsEntry(e)) continue;
            notFound.add(e);
        }
        if (!notFound.isEmpty()) {
            this.failIfNotFound(this.entryOrEntries(notFound), notFound);
        }
        return this;
    }

    public MapAssert excludes(Entry ... entries) {
        this.isNotNull();
        this.validate(ENTRIES, entries);
        ArrayList<Entry> found = new ArrayList<Entry>();
        for (Entry e : entries) {
            if (!this.containsEntry(e)) continue;
            found.add(e);
        }
        if (!found.isEmpty()) {
            this.failIfFound(this.entryOrEntries(found), found);
        }
        return this;
    }

    private boolean containsEntry(Entry e) {
        if (e == null) {
            throw new NullPointerException(this.formattedErrorMessage("Entries to check should not contain null"));
        }
        if (!((Map)this.actual).containsKey(e.key)) {
            return false;
        }
        return ((Map)this.actual).get(e.key).equals(e.value);
    }

    private String entryOrEntries(List<Entry> found) {
        return found.size() == 1 ? ENTRY : ENTRIES;
    }

    public static Entry entry(Object key, Object value) {
        return new Entry(key, value);
    }

    private void failIfNotFound(String description, Collection<?> notFound) {
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat((Object[])new Object[]{"the map:", this.formattedActual(), " does not contain the ", description, ":", Formatting.inBrackets(notFound)}));
    }

    private void validate(String description, Object[] objects) {
        if (objects == null) {
            throw new NullPointerException(this.formattedErrorMessage(Strings.concat((Object[])new Object[]{"The given array of ", description, " should not be null"})));
        }
    }

    private void failIfFound(String description, Collection<?> found) {
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat((Object[])new Object[]{"the map:", this.formattedActual(), " contains the ", description, ":", Formatting.inBrackets(found)}));
    }

    public MapAssert hasSize(int expected) {
        this.isNotNull();
        int actualSize = this.actualGroupSize();
        if (actualSize == expected) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{"expected size:", Formatting.inBrackets(expected), " but was:", Formatting.inBrackets(actualSize), " for map:", Formatting.inBrackets(this.actual)}));
    }

    private String formattedActual() {
        return Formatting.inBrackets(this.actual);
    }

    public MapAssert isEqualTo(Map<?, ?> expected) {
        this.assertEqualTo(expected);
        return this;
    }

    public MapAssert isNotEmpty() {
        this.assertIsNotEmpty();
        return this;
    }

    public MapAssert isNotEqualTo(Map<?, ?> other) {
        this.assertNotEqualTo(other);
        return this;
    }

    public MapAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public MapAssert isNotSameAs(Map<?, ?> other) {
        this.assertNotSameAs(other);
        return this;
    }

    public MapAssert isSameAs(Map<?, ?> expected) {
        this.assertSameAs(expected);
        return this;
    }

    public MapAssert satisfies(Condition<Map<?, ?>> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public MapAssert doesNotSatisfy(Condition<Map<?, ?>> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public MapAssert is(Condition<Map<?, ?>> condition) {
        this.assertIs(condition);
        return this;
    }

    public MapAssert isNot(Condition<Map<?, ?>> condition) {
        this.assertIsNot(condition);
        return this;
    }

    @Override
    protected int actualGroupSize() {
        this.isNotNull();
        return ((Map)this.actual).size();
    }

    @Override
    public MapAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }

    public static class Entry {
        final Object key;
        final Object value;

        Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return Strings.concat((Object[])new Object[]{Strings.quote((Object)this.key), "=", Strings.quote((Object)this.value)});
        }
    }
}

