/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Formatting;
import org.fest.assertions.ObjectGroupAssert;
import org.fest.assertions.PropertySupport;
import org.fest.util.Collections;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArrayAssert
extends ObjectGroupAssert<Object[]> {
    protected ObjectArrayAssert(Object ... actual) {
        super(actual);
    }

    @Override
    public ObjectArrayAssert as(String description) {
        this.description(description);
        return this;
    }

    @Override
    public ObjectArrayAssert describedAs(String description) {
        return this.as(description);
    }

    @Override
    public ObjectArrayAssert as(Description description) {
        this.description(description);
        return this;
    }

    @Override
    public ObjectArrayAssert describedAs(Description description) {
        return this.as(description);
    }

    public ObjectArrayAssert hasAllElementsOfType(Class<?> type) {
        this.validateIsNotNull(type);
        this.isNotNull();
        for (Object o : (Object[])this.actual) {
            if (type.isInstance(o)) continue;
            this.failIfCustomMessageIsSet();
            this.fail(Strings.concat((Object[])new Object[]{"not all elements in array:", Formatting.inBrackets(this.actual), " belong to the type:", Formatting.inBrackets(type)}));
        }
        return this;
    }

    public ObjectArrayAssert hasAtLeastOneElementOfType(Class<?> type) {
        this.validateIsNotNull(type);
        this.isNotNull();
        boolean found = false;
        for (Object o : (Object[])this.actual) {
            if (!type.isInstance(o)) continue;
            found = true;
            break;
        }
        if (found) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{"array:", Formatting.inBrackets(this.actual), " does not have any elements of type:", Formatting.inBrackets(type)}));
    }

    private void validateIsNotNull(Class<?> type) {
        if (type == null) {
            throw new NullPointerException(ErrorMessages.unexpectedNullType(this.rawDescription()));
        }
    }

    public ObjectArrayAssert contains(Object ... objects) {
        this.assertContains(objects);
        return this;
    }

    public ObjectArrayAssert containsOnly(Object ... objects) {
        this.assertContainsOnly(objects);
        return this;
    }

    public ObjectArrayAssert excludes(Object ... objects) {
        this.assertExcludes(objects);
        return this;
    }

    public ObjectArrayAssert doesNotHaveDuplicates() {
        this.assertDoesNotHaveDuplicates();
        return this;
    }

    public ObjectArrayAssert satisfies(Condition<Object[]> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public ObjectArrayAssert doesNotSatisfy(Condition<Object[]> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public ObjectArrayAssert is(Condition<Object[]> condition) {
        this.assertIs(condition);
        return this;
    }

    public ObjectArrayAssert isNot(Condition<Object[]> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public ObjectArrayAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public ObjectArrayAssert isNotEmpty() {
        this.assertIsNotEmpty();
        return this;
    }

    public ObjectArrayAssert isEqualTo(Object[] expected) {
        if (Arrays.deepEquals((Object[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    public ObjectArrayAssert isNotEqualTo(Object[] array) {
        if (!Arrays.deepEquals((Object[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }

    public ObjectArrayAssert hasSize(int expected) {
        this.assertHasSize(expected);
        return this;
    }

    public ObjectArrayAssert isSameAs(Object[] expected) {
        this.assertSameAs(expected);
        return this;
    }

    public ObjectArrayAssert isNotSameAs(Object[] expected) {
        this.assertNotSameAs(expected);
        return this;
    }

    @Override
    public ObjectArrayAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }

    public ObjectArrayAssert onProperty(String propertyName) {
        this.isNotNull();
        if (((Object[])this.actual).length == 0) {
            return new ObjectArrayAssert(new Object[0]);
        }
        return new ObjectArrayAssert(PropertySupport.propertyValues(propertyName, Collections.list((Object[])((Object[])this.actual))).toArray());
    }

    @Override
    protected Set<Object> actualAsSet() {
        return ObjectArrayAssert.asSet((Object[])this.actual);
    }

    @Override
    protected List<Object> actualAsList() {
        return Collections.list((Object[])((Object[])this.actual));
    }

    @Override
    protected int actualGroupSize() {
        return ((Object[])this.actual).length;
    }
}

