/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.NumberAssert;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortAssert
extends GenericAssert<Short>
implements NumberAssert {
    private static final short ZERO = 0;

    @VisibleForTesting
    ShortAssert(int actual) {
        this((short)actual);
    }

    protected ShortAssert(short actual) {
        super(actual);
    }

    protected ShortAssert(Short actual) {
        super(actual);
    }

    public ShortAssert as(String description) {
        this.description(description);
        return this;
    }

    public ShortAssert describedAs(String description) {
        return this.as(description);
    }

    public ShortAssert as(Description description) {
        this.description(description);
        return this;
    }

    public ShortAssert describedAs(Description description) {
        return this.as(description);
    }

    public ShortAssert isEqualTo(short expected) {
        return this.isEqualTo((Short)expected);
    }

    public ShortAssert isEqualTo(Short expected) {
        this.assertEqualTo(expected);
        return this;
    }

    public ShortAssert isNotEqualTo(short other) {
        return this.isNotEqualTo((Short)other);
    }

    public ShortAssert isNotEqualTo(Short other) {
        this.assertNotEqualTo(other);
        return this;
    }

    public ShortAssert isGreaterThan(short other) {
        if ((Short)this.actual > other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, other));
    }

    public ShortAssert isLessThan(short other) {
        if ((Short)this.actual < other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, other));
    }

    public ShortAssert isGreaterThanOrEqualTo(short other) {
        if ((Short)this.actual >= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, other));
    }

    public ShortAssert isLessThanOrEqualTo(short other) {
        if ((Short)this.actual <= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, other));
    }

    @Override
    public ShortAssert isZero() {
        return this.isEqualTo((short)0);
    }

    @Override
    public ShortAssert isPositive() {
        return this.isGreaterThan((short)0);
    }

    @Override
    public ShortAssert isNegative() {
        return this.isLessThan((short)0);
    }

    public ShortAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }

    public ShortAssert satisfies(Condition<Short> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public ShortAssert doesNotSatisfy(Condition<Short> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public ShortAssert is(Condition<Short> condition) {
        this.assertIs(condition);
        return this;
    }

    public ShortAssert isNot(Condition<Short> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public ShortAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public ShortAssert isSameAs(Short expected) {
        this.assertSameAs(expected);
        return this;
    }

    public ShortAssert isNotSameAs(Short other) {
        this.assertNotSameAs(other);
        return this;
    }
}

