/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.Formatting;
import org.fest.assertions.GroupAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringAssert
extends GroupAssert<String> {
    protected StringAssert(String actual) {
        super(actual);
    }

    @Override
    public StringAssert as(String description) {
        this.description(description);
        return this;
    }

    @Override
    public StringAssert describedAs(String description) {
        return this.as(description);
    }

    @Override
    public StringAssert as(Description description) {
        this.description(description);
        return this;
    }

    @Override
    public StringAssert describedAs(Description description) {
        return this.as(description);
    }

    public StringAssert satisfies(Condition<String> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public StringAssert doesNotSatisfy(Condition<String> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public StringAssert is(Condition<String> condition) {
        this.assertIs(condition);
        return this;
    }

    public StringAssert isNot(Condition<String> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public StringAssert isNotEmpty() {
        this.assertIsNotEmpty();
        return this;
    }

    public StringAssert isEqualTo(String expected) {
        this.assertEqualTo(expected);
        return this;
    }

    public StringAssert isEqualToIgnoringCase(String expected) {
        if (this.actual == null && expected == null) {
            return this;
        }
        this.isNotNull();
        if (((String)this.actual).equalsIgnoreCase(expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{this.actual(), " should be equal to :", Formatting.inBrackets(expected), " ignoring case"}));
    }

    public StringAssert isNotEqualTo(String other) {
        this.assertNotEqualTo(other);
        return this;
    }

    public StringAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public StringAssert isNotSameAs(String other) {
        this.assertNotSameAs(other);
        return this;
    }

    public StringAssert isSameAs(String expected) {
        this.assertSameAs(expected);
        return this;
    }

    public StringAssert hasSize(int expected) {
        this.assertHasSize(expected);
        return this;
    }

    @Override
    protected int actualGroupSize() {
        this.isNotNull();
        return ((String)this.actual).length();
    }

    public StringAssert contains(String expected) {
        this.isNotNull();
        if (((String)this.actual).indexOf(expected) != -1) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{this.actual(), " should contain the String:", Formatting.inBrackets(expected)}));
    }

    public StringAssert endsWith(String expected) {
        this.isNotNull();
        if (((String)this.actual).endsWith(expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{this.actual(), " should end with:", Formatting.inBrackets(expected)}));
    }

    public StringAssert startsWith(String expected) {
        this.isNotNull();
        if (((String)this.actual).startsWith(expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{this.actual(), " should start with:", Formatting.inBrackets(expected)}));
    }

    public StringAssert excludes(String s) {
        this.isNotNull();
        if (((String)this.actual).indexOf(s) == -1) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{this.actual(), " should not contain the String:", Formatting.inBrackets(s)}));
    }

    public StringAssert matches(String regex) {
        this.isNotNull();
        if (((String)this.actual).matches(regex)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{this.actual(), " should match the regular expression:", Formatting.inBrackets(regex)}));
    }

    public StringAssert doesNotMatch(String regex) {
        this.isNotNull();
        if (!((String)this.actual).matches(regex)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{this.actual(), " should not match the regular expression:", Formatting.inBrackets(regex)}));
    }

    private String actual() {
        return Formatting.inBrackets(this.actual);
    }

    @Override
    public StringAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }

    public StringAssert containsIgnoringCase(String text) {
        StringAssert.validateNotNull(text);
        this.isNotNull();
        if (((String)this.actual).toLowerCase().contains(text.toLowerCase())) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{this.actual(), " does not contain ", Formatting.inBrackets(text)}));
    }

    public StringAssert doesNotContain(String text) {
        StringAssert.validateNotNull(text);
        this.isNotNull();
        if (!((String)this.actual).contains(text)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{this.actual(), " should not contain ", Formatting.inBrackets(text)}));
    }

    private static void validateNotNull(String text) {
        if (text == null) {
            throw new NullPointerException("The given String should not be null");
        }
    }
}

