/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.fest.assertions.Formatting;
import org.fest.assertions.Index;
import org.fest.assertions.ObjectGroupAssert;
import org.fest.assertions.PropertySupport;
import org.fest.util.Collections;
import org.fest.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListAssert
extends ObjectGroupAssert<ListAssert, List<?>> {
    protected ListAssert(List<?> actual) {
        super(ListAssert.class, actual);
    }

    public ListAssert contains(Object o, Index index) {
        Object actualElement;
        if (index == null) {
            throw new NullPointerException(this.formattedErrorMessage("The given index should not be null"));
        }
        ((ListAssert)this.isNotNull()).isNotEmpty();
        int indexValue = index.value();
        int listSize = this.actualGroupSize();
        if (indexValue < 0 || indexValue >= listSize) {
            this.failIndexOutOfBounds(indexValue);
        }
        if (!Objects.areEqual(actualElement = ((List)this.actual).get(indexValue), (Object)o)) {
            this.failElementNotFound(o, actualElement, indexValue);
        }
        return this;
    }

    private void failElementNotFound(Object e, Object a, int index) {
        this.failIfCustomMessageIsSet();
        this.fail(Formatting.format("expecting <%s> at index <%s> but found <%s>", e, index, a));
    }

    private void failIndexOutOfBounds(int index) {
        throw new IndexOutOfBoundsException(this.formattedErrorMessage(Formatting.format("The index <%s> should be greater than or equal to zero and less than %s", index, this.actualGroupSize())));
    }

    public ListAssert containsSequence(Object ... sequence) {
        this.isNotNull();
        this.validateIsNotNull(sequence);
        int sequenceSize = sequence.length;
        if (sequenceSize == 0) {
            return this;
        }
        int indexOfFirst = ((List)this.actual).indexOf(sequence[0]);
        if (indexOfFirst == -1) {
            this.failIfSequenceNotFound(sequence);
        }
        int listSize = this.actualGroupSize();
        for (int i = 0; i < sequenceSize; ++i) {
            int actualIndex = indexOfFirst + i;
            if (actualIndex > listSize - 1) {
                this.failIfSequenceNotFound(sequence);
            }
            if (Objects.areEqual((Object)sequence[i], ((List)this.actual).get(actualIndex))) continue;
            this.failIfSequenceNotFound(sequence);
        }
        return this;
    }

    private void failIfSequenceNotFound(Object[] notFound) {
        this.failIfCustomMessageIsSet();
        this.fail(Formatting.format("list:<%s> does not contain the sequence:<%s>", this.actual, notFound));
    }

    public ListAssert startsWith(Object ... sequence) {
        this.isNotNull();
        this.validateIsNotNull(sequence);
        int sequenceSize = sequence.length;
        int listSize = this.actualGroupSize();
        if (sequenceSize == 0 && listSize == 0) {
            return this;
        }
        if (sequenceSize == 0 && listSize != 0) {
            this.failIfNotStartingWithSequence(sequence);
        }
        if (listSize < sequenceSize) {
            this.failIfNotStartingWithSequence(sequence);
        }
        for (int i = 0; i < sequenceSize; ++i) {
            if (Objects.areEqual((Object)sequence[i], ((List)this.actual).get(i))) continue;
            this.failIfNotStartingWithSequence(sequence);
        }
        return this;
    }

    private void failIfNotStartingWithSequence(Object[] notFound) {
        this.failIfCustomMessageIsSet();
        this.fail(Formatting.format("list:<%s> does not start with the sequence:<%s>", this.actual, notFound));
    }

    public ListAssert endsWith(Object ... sequence) {
        this.isNotNull();
        this.validateIsNotNull(sequence);
        int sequenceSize = sequence.length;
        int listSize = this.actualGroupSize();
        if (sequenceSize == 0 && listSize == 0) {
            return this;
        }
        if (sequenceSize == 0 && listSize != 0) {
            this.failIfNotEndingWithSequence(sequence);
        }
        if (listSize < sequenceSize) {
            this.failIfNotEndingWithSequence(sequence);
        }
        for (int i = 0; i < sequenceSize; ++i) {
            int sequenceIndex = sequenceSize - 1 - i;
            int listIndex = listSize - 1 - i;
            if (Objects.areEqual((Object)sequence[sequenceIndex], ((List)this.actual).get(listIndex))) continue;
            this.failIfNotEndingWithSequence(sequence);
        }
        return this;
    }

    private void failIfNotEndingWithSequence(Object[] notFound) {
        this.failIfCustomMessageIsSet();
        this.fail(Formatting.format("list:<%s> does not end with the sequence:<%s>", this.actual, notFound));
    }

    @Override
    protected int actualGroupSize() {
        this.isNotNull();
        return ((List)this.actual).size();
    }

    public ListAssert containsExactly(Object ... objects) {
        this.validateIsNotNull(objects);
        return (ListAssert)((ListAssert)this.isNotNull()).isEqualTo(Collections.list((Object[])objects));
    }

    @Override
    public ListAssert onProperty(String propertyName) {
        this.isNotNull();
        if (((List)this.actual).isEmpty()) {
            return new ListAssert(java.util.Collections.emptyList());
        }
        return new ListAssert(PropertySupport.instance().propertyValues(propertyName, (Collection)this.actual));
    }

    @Override
    protected Set<Object> actualAsSet() {
        return new LinkedHashSet<Object>((Collection)this.actual);
    }

    @Override
    protected List<Object> actualAsList() {
        return new ArrayList<Object>((Collection)this.actual);
    }
}

