/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.ErrorMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortArrayAssert
extends ArrayAssert<ShortArrayAssert, short[]> {
    protected ShortArrayAssert(short ... actual) {
        super(ShortArrayAssert.class, actual);
    }

    public ShortArrayAssert contains(short ... values) {
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    public ShortArrayAssert containsOnly(short ... values) {
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    public ShortArrayAssert excludes(short ... values) {
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    @Override
    public ShortArrayAssert isEqualTo(short[] expected) {
        if (Arrays.equals((short[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    @Override
    public ShortArrayAssert isNotEqualTo(short[] array) {
        if (!Arrays.equals((short[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }
}

