/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.field;

import java.lang.reflect.Field;
import org.fest.reflect.exception.ReflectionError;
import org.fest.reflect.reference.TypeRef;
import org.fest.reflect.util.Accessibles;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Invoker<T> {
    private final Object target;
    private final Field field;
    private final boolean accessible;

    Invoker(String fieldName, Class<?> target) {
        if (target == null) {
            throw new NullPointerException("Target should not be null");
        }
        this.target = target;
        this.field = Invoker.lookupInClassHierarchy(fieldName, target);
        this.accessible = this.field.isAccessible();
    }

    Invoker(String fieldName, Object target) {
        this.target = target;
        Class<?> type = target.getClass();
        this.field = Invoker.lookupInClassHierarchy(fieldName, type);
        this.accessible = this.field.isAccessible();
    }

    private static Field lookupInClassHierarchy(String fieldName, Class<?> declaringType) {
        Field field = null;
        Class<?> target = declaringType;
        while (target != null) {
            field = Invoker.field(fieldName, target);
            if (field != null) break;
            target = target.getSuperclass();
        }
        if (field != null) {
            return field;
        }
        throw new ReflectionError(Strings.concat((Object[])new Object[]{"Unable to find field ", Strings.quote((String)fieldName), " in ", declaringType.getName()}));
    }

    private static Field field(String fieldName, Class<?> declaringType) {
        try {
            return declaringType.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    void verifyCorrectType(TypeRef<?> expectedType) {
        this.verifyCorrectType(expectedType.rawType());
    }

    void verifyCorrectType(Class<?> expectedType) {
        boolean isAccessible = this.field.isAccessible();
        try {
            Accessibles.makeAccessible(this.field);
            Class<?> actualType = this.field.getType();
            if (!expectedType.isAssignableFrom(actualType)) {
                throw Invoker.incorrectFieldType(this.field, actualType, expectedType);
            }
        }
        finally {
            Accessibles.setAccessibleIgnoringExceptions(this.field, isAccessible);
        }
    }

    private static ReflectionError incorrectFieldType(Field field, Class<?> actualType, Class<?> expectedType) {
        String fieldTypeName = field.getDeclaringClass().getName();
        String message = Strings.concat((Object[])new Object[]{"The type of the field ", Strings.quote((String)field.getName()), " in ", fieldTypeName, " should be <", expectedType.getName(), "> but was <", actualType.getName(), ">"});
        throw new ReflectionError(message);
    }

    public void set(T value) {
        try {
            try {
                Accessibles.setAccessible(this.field, true);
                this.field.set(this.target, value);
            }
            catch (Exception e) {
                throw new ReflectionError(Strings.concat((Object[])new Object[]{"Unable to update the value in field ", Strings.quote((String)this.field.getName())}), e);
            }
        }
        finally {
            Accessibles.setAccessibleIgnoringExceptions(this.field, this.accessible);
        }
    }

    public T get() {
        try {
            Accessibles.setAccessible(this.field, true);
            Object object = this.field.get(this.target);
            return (T)object;
        }
        catch (Exception e) {
            throw new ReflectionError(Strings.concat((Object[])new Object[]{"Unable to obtain the value in field " + Strings.quote((String)this.field.getName())}), e);
        }
        finally {
            Accessibles.setAccessibleIgnoringExceptions(this.field, this.accessible);
        }
    }

    public Field info() {
        return this.field;
    }
}

