/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.field;

import java.util.List;
import org.fest.reflect.field.Invoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldType<T> {
    private final List<String> path;
    private final String name;
    private final Class<T> type;

    static <T> FieldType<T> newFieldType(String name, Class<T> type, List<String> path) {
        if (type == null) {
            throw new NullPointerException("The type of the field to access should not be null");
        }
        return new FieldType<T>(name, type, path);
    }

    private FieldType(String name, Class<T> type, List<String> path) {
        this.name = name;
        this.type = type;
        this.path = path;
    }

    public Invoker<T> in(Object target) {
        Object nestedTarget = null;
        for (String fieldName : this.path) {
            nestedTarget = Invoker.getNestedField(fieldName, nestedTarget == null ? target : nestedTarget);
        }
        return Invoker.newInvoker(this.name, this.type, nestedTarget == null ? target : nestedTarget);
    }
}

