/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpointGroups;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.BreakpointGroupMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.model.AdaptableList;

public class SelectBreakpointWorkingsetDialog
extends SelectionDialog {
    private static final String SETTINGS_ID = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".DELETE_ASSOCIATED_CONFIGS_DIALOG";
    private Object fInitialSelection = null;
    private Object[] fResult = null;
    private CheckboxTableViewer fViewer = null;

    protected SelectBreakpointWorkingsetDialog(Shell parentShell, Object selection) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fInitialSelection = selection;
    }

    private IWorkingSet[] getBreakpointWorkingSets() {
        IWorkingSet[] ws = PlatformUI.getWorkbench().getWorkingSetManager().getAllWorkingSets();
        ArrayList<IWorkingSet> list = new ArrayList<IWorkingSet>();
        int i = 0;
        while (i < ws.length) {
            if ("org.eclipse.debug.ui.breakpointWorkingSet".equals(ws[i].getId())) {
                list.add(ws[i]);
            }
            ++i;
        }
        return list.toArray(new IWorkingSet[list.size()]);
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite comp = (Composite)super.createDialogArea(parent);
        SWTFactory.createLabel(comp, BreakpointGroupMessages.SelectBreakpointWorkingsetDialog_0, 2);
        Table table = new Table(comp, 2852);
        this.fViewer = new CheckboxTableViewer(table);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        table.setLayoutData((Object)gd);
        this.fViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fViewer.setInput((Object)new AdaptableList((IAdaptable[])this.getBreakpointWorkingSets()).getChildren());
        this.fViewer.setLabelProvider((IBaseLabelProvider)DebugUITools.newDebugModelPresentation());
        if (this.fInitialSelection != null) {
            this.fViewer.setChecked(this.fInitialSelection, true);
        }
        this.fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SelectBreakpointWorkingsetDialog.this.fViewer.setCheckedElements(new Object[]{event.getElement()});
                SelectBreakpointWorkingsetDialog.this.getButton(0).setEnabled(true);
            }
        });
        Dialog.applyDialogFont((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, "org.eclipse.debug.ui.select_breakpoint_workingset_dialog");
        return comp;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setEnabled(this.fViewer.getCheckedElements().length > 0);
        return control;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGS_ID);
        if (section == null) {
            section = settings.addNewSection(SETTINGS_ID);
        }
        return section;
    }

    protected Point getInitialSize() {
        IDialogSettings settings = this.getDialogBoundsSettings();
        if (settings != null) {
            try {
                int width = settings.getInt("DIALOG_WIDTH");
                int height = settings.getInt("DIALOG_HEIGHT");
                if (width > 0 & height > 0) {
                    return new Point(width, height);
                }
            }
            catch (NumberFormatException numberFormatException) {
                return new Point(350, 400);
            }
        }
        return new Point(350, 400);
    }

    public Object[] getResult() {
        return this.fResult;
    }

    protected void okPressed() {
        this.fResult = this.fViewer.getCheckedElements();
        super.okPressed();
    }
}

