/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane;

import java.security.PrivateKey;
import java.time.Clock;
import java.util.function.Supplier;
import org.eclipse.edc.connector.api.control.configuration.ControlApiConfiguration;
import org.eclipse.edc.connector.dataplane.selector.spi.DataPlaneSelectorService;
import org.eclipse.edc.connector.dataplane.selector.spi.client.DataPlaneClientFactory;
import org.eclipse.edc.connector.transfer.dataplane.api.ConsumerPullTransferTokenValidationApiController;
import org.eclipse.edc.connector.transfer.dataplane.flow.ConsumerPullTransferDataFlowController;
import org.eclipse.edc.connector.transfer.dataplane.flow.ProviderPushTransferDataFlowController;
import org.eclipse.edc.connector.transfer.dataplane.proxy.ConsumerPullDataPlaneProxyResolver;
import org.eclipse.edc.connector.transfer.dataplane.spi.security.DataEncrypter;
import org.eclipse.edc.connector.transfer.dataplane.spi.token.ConsumerPullTokenExpirationDateFunction;
import org.eclipse.edc.connector.transfer.dataplane.validation.ExpirationDateValidationRule;
import org.eclipse.edc.connector.transfer.spi.callback.ControlApiUrl;
import org.eclipse.edc.connector.transfer.spi.flow.DataFlowController;
import org.eclipse.edc.connector.transfer.spi.flow.DataFlowManager;
import org.eclipse.edc.keys.spi.LocalPublicKeyService;
import org.eclipse.edc.keys.spi.PrivateKeyResolver;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.token.JwtGenerationService;
import org.eclipse.edc.token.spi.TokenGenerationService;
import org.eclipse.edc.token.spi.TokenValidationRule;
import org.eclipse.edc.token.spi.TokenValidationRulesRegistry;
import org.eclipse.edc.token.spi.TokenValidationService;
import org.eclipse.edc.validator.spi.DataAddressValidatorRegistry;
import org.eclipse.edc.validator.spi.ValidationResult;
import org.eclipse.edc.web.spi.WebService;
import org.jetbrains.annotations.NotNull;

@Extension(value="Transfer Data Plane Core")
public class TransferDataPlaneCoreExtension
implements ServiceExtension {
    @Setting(value="Alias of private key used for signing tokens, retrieved from private key resolver")
    public static final String TOKEN_SIGNER_PRIVATE_KEY_ALIAS = "edc.transfer.proxy.token.signer.privatekey.alias";
    @Setting(value="Alias of public key used for verifying the tokens, retrieved from the vault")
    public static final String TOKEN_VERIFIER_PUBLIC_KEY_ALIAS = "edc.transfer.proxy.token.verifier.publickey.alias";
    public static final String NAME = "Transfer Data Plane Core";
    public static final String TRANSFER_DATAPLANE_TOKEN_CONTEXT = "dataplane-transfer";
    @Inject
    private WebService webService;
    @Inject
    private DataFlowManager dataFlowManager;
    @Inject
    private Clock clock;
    @Inject
    private DataEncrypter dataEncrypter;
    @Inject
    private ControlApiConfiguration controlApiConfiguration;
    @Inject
    private DataPlaneSelectorService selectorService;
    @Inject
    private DataPlaneClientFactory clientFactory;
    @Inject
    private ConsumerPullTokenExpirationDateFunction tokenExpirationDateFunction;
    @Inject(required=false)
    private ControlApiUrl callbackUrl;
    @Inject
    private TypeManager typeManager;
    @Inject
    private LocalPublicKeyService publicKeyService;
    @Inject
    private PrivateKeyResolver privateKeyResolver;
    @Inject
    private DataAddressValidatorRegistry dataAddressValidatorRegistry;
    @Inject
    private TokenValidationRulesRegistry tokenValidationRulesRegistry;
    @Inject
    private TokenValidationService tokenValidationService;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        String publicKeyAlias = context.getSetting(TOKEN_VERIFIER_PUBLIC_KEY_ALIAS, null);
        String privateKeyAlias = context.getSetting(TOKEN_SIGNER_PRIVATE_KEY_ALIAS, null);
        if (publicKeyAlias != null && privateKeyAlias != null) {
            ConsumerPullTransferTokenValidationApiController controller = new ConsumerPullTransferTokenValidationApiController(this.tokenValidationService, this.dataEncrypter, this.typeManager, i -> this.publicKeyService.resolveKey(publicKeyAlias));
            this.webService.registerResource(this.controlApiConfiguration.getContextAlias(), (Object)controller);
            ConsumerPullDataPlaneProxyResolver resolver = new ConsumerPullDataPlaneProxyResolver(this.dataEncrypter, this.typeManager, (TokenGenerationService)new JwtGenerationService(), this.getPrivateKeySupplier(context, privateKeyAlias), () -> publicKeyAlias, this.tokenExpirationDateFunction);
            this.dataFlowManager.register((DataFlowController)new ConsumerPullTransferDataFlowController(this.selectorService, resolver));
        } else {
            context.getMonitor().info("One of these settings is not configured, so the connector won't be able to provide 'consumer-pull' transfers: [%s, %s]".formatted(TOKEN_VERIFIER_PUBLIC_KEY_ALIAS, TOKEN_SIGNER_PRIVATE_KEY_ALIAS), new Throwable[0]);
        }
        this.tokenValidationRulesRegistry.addRule(TRANSFER_DATAPLANE_TOKEN_CONTEXT, (TokenValidationRule)new ExpirationDateValidationRule(this.clock));
        this.dataFlowManager.register((DataFlowController)new ProviderPushTransferDataFlowController(this.callbackUrl, this.selectorService, this.clientFactory));
        this.dataAddressValidatorRegistry.registerDestinationValidator("HttpProxy", dataAddress -> ValidationResult.success());
    }

    @NotNull
    private Supplier<PrivateKey> getPrivateKeySupplier(ServiceExtensionContext context, String privateKeyAlias) {
        return () -> (PrivateKey)this.privateKeyResolver.resolvePrivateKey(privateKeyAlias).orElse(f -> {
            context.getMonitor().warning("Cannot resolve private key: " + f.getFailureDetail(), new Throwable[0]);
            return null;
        });
    }
}

