/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane;

import java.time.Clock;
import java.util.Date;
import org.eclipse.edc.connector.transfer.dataplane.security.NoopDataEncrypter;
import org.eclipse.edc.connector.transfer.dataplane.spi.security.DataEncrypter;
import org.eclipse.edc.connector.transfer.dataplane.spi.token.ConsumerPullTokenExpirationDateFunction;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provider;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;

public class TransferDataPlaneDefaultServicesExtension
implements ServiceExtension {
    private static final String DEFAULT_TOKEN_VALIDITY_SECONDS = "600";
    @Setting(value="Validity (in seconds) of tokens issued by the Control Plane for targeting the Data Plane public API.", type="long", defaultValue="600")
    private static final String TOKEN_VALIDITY_SECONDS = "edc.transfer.proxy.token.validity.seconds";
    public static final String NAME = "Transfer Data Plane Default Services";
    @Inject
    private Clock clock;

    public String name() {
        return NAME;
    }

    @Provider(isDefault=true)
    public DataEncrypter getDataEncrypter(ServiceExtensionContext context) {
        context.getMonitor().warning("No DataEncrypter registered, a no-op implementation will be used, not suitable for production environments", new Throwable[0]);
        return new NoopDataEncrypter();
    }

    @Provider(isDefault=true)
    public ConsumerPullTokenExpirationDateFunction tokenExpirationDateFunction(ServiceExtensionContext context) {
        int validity = context.getSetting(TOKEN_VALIDITY_SECONDS, Integer.parseInt(DEFAULT_TOKEN_VALIDITY_SECONDS));
        return (contentAddress, contractId) -> Result.success((Object)Date.from(this.clock.instant().plusSeconds(validity)));
    }
}

