/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane.proxy;

import java.security.PrivateKey;
import java.util.Date;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.connector.transfer.dataplane.proxy.ConsumerPullDataPlaneProxyTokenDecorator;
import org.eclipse.edc.connector.transfer.dataplane.spi.security.DataEncrypter;
import org.eclipse.edc.connector.transfer.dataplane.spi.token.ConsumerPullTokenExpirationDateFunction;
import org.eclipse.edc.connector.transfer.spi.types.TransferProcess;
import org.eclipse.edc.spi.iam.TokenRepresentation;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.token.spi.KeyIdDecorator;
import org.eclipse.edc.token.spi.TokenDecorator;
import org.eclipse.edc.token.spi.TokenGenerationService;

public class ConsumerPullDataPlaneProxyResolver {
    private static final String PUBLIC_API_URL_PROPERTY_DEPRECATED = "publicApiUrl";
    private static final String PUBLIC_API_URL_PROPERTY = "https://w3id.org/edc/v0.0.1/ns/publicApiUrl";
    private final DataEncrypter dataEncrypter;
    private final TypeManager typeManager;
    private final TokenGenerationService tokenGenerationService;
    private final Supplier<PrivateKey> keySupplier;
    private final Supplier<String> publicKeyIdSupplier;
    private final ConsumerPullTokenExpirationDateFunction tokenExpirationDateFunction;

    public ConsumerPullDataPlaneProxyResolver(DataEncrypter dataEncrypter, TypeManager typeManager, TokenGenerationService tokenGenerationService, Supplier<PrivateKey> keySupplier, Supplier<String> publicKeyIdSupplier, ConsumerPullTokenExpirationDateFunction tokenExpirationDateFunction) {
        this.dataEncrypter = dataEncrypter;
        this.typeManager = typeManager;
        this.tokenExpirationDateFunction = tokenExpirationDateFunction;
        this.tokenGenerationService = tokenGenerationService;
        this.keySupplier = keySupplier;
        this.publicKeyIdSupplier = publicKeyIdSupplier;
    }

    private static Object getPublicApiUrl(DataPlaneInstance instance) {
        return Optional.ofNullable(instance.getProperties().get(PUBLIC_API_URL_PROPERTY)).orElseGet(() -> instance.getProperties().get(PUBLIC_API_URL_PROPERTY_DEPRECATED));
    }

    public Result<DataAddress> toDataAddress(TransferProcess transferProcess, DataAddress address, DataPlaneInstance instance) {
        return (Result)this.resolveProxyUrl(instance).compose(proxyUrl -> (Result)this.generateAccessToken(address, transferProcess.getContractId()).map(token -> DataAddress.Builder.newInstance().type("EDR").property("https://w3id.org/edc/v0.0.1/ns/id", (Object)transferProcess.getCorrelationId()).property("https://w3id.org/edc/v0.0.1/ns/contractId", (Object)transferProcess.getContractId()).property("https://w3id.org/edc/v0.0.1/ns/endpoint", proxyUrl).property("https://w3id.org/edc/v0.0.1/ns/authKey", (Object)"Authorization").property("https://w3id.org/edc/v0.0.1/ns/authCode", token).build()));
    }

    private Result<String> resolveProxyUrl(DataPlaneInstance instance) {
        return Optional.ofNullable(ConsumerPullDataPlaneProxyResolver.getPublicApiUrl(instance)).map(url -> Result.success((Object)((String)url))).orElse(Result.failure((String)String.format("Missing property `%s` (deprecated: `%s`) in DataPlaneInstance", PUBLIC_API_URL_PROPERTY, PUBLIC_API_URL_PROPERTY_DEPRECATED)));
    }

    private Result<String> generateAccessToken(DataAddress source, String contractId) {
        String encryptedDataAddress = this.dataEncrypter.encrypt(this.typeManager.writeValueAsString((Object)source));
        return (Result)((Result)this.tokenExpirationDateFunction.expiresAt(source, contractId).compose(expiration -> {
            KeyIdDecorator keyIdDecorator = new KeyIdDecorator(this.publicKeyIdSupplier.get());
            ConsumerPullDataPlaneProxyTokenDecorator dataAddressDecorator = new ConsumerPullDataPlaneProxyTokenDecorator((Date)expiration, encryptedDataAddress);
            return this.tokenGenerationService.generate(this.keySupplier, new TokenDecorator[]{keyIdDecorator, dataAddressDecorator});
        })).map(TokenRepresentation::getToken);
    }
}

