/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane.validation;

import java.time.Clock;
import java.time.Instant;
import java.util.Map;
import org.eclipse.edc.spi.iam.ClaimToken;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.token.spi.TokenValidationRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpirationDateValidationRule
implements TokenValidationRule {
    private final Clock clock;

    public ExpirationDateValidationRule(Clock clock) {
        this.clock = clock;
    }

    public Result<Void> checkRule(@NotNull ClaimToken toVerify, @Nullable Map<String, Object> additional) {
        Instant expiration = toVerify.getInstantClaim("exp");
        if (expiration == null) {
            return Result.failure((String)"Missing expiration time in token");
        }
        if (this.clock.instant().isAfter(expiration)) {
            return Result.failure((String)("Token has expired on " + expiration));
        }
        return Result.success();
    }
}

